/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.store;

import com.atlassian.confluence.efi.store.UserStorageService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserStorageServiceImpl
implements UserStorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStorageServiceImpl.class);
    private final UserAccessor userAccessor;

    @Autowired
    public UserStorageServiceImpl(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public String get(String key, ConfluenceUser user) {
        return this.userAccessor.getUserPreferences(user).getString("efi.store.onboarding." + key).orElse(null);
    }

    @Override
    public void set(String key, String value, ConfluenceUser user) {
        try {
            this.userAccessor.getUserPreferences(user).setString("efi.store.onboarding." + key, value);
        }
        catch (UserPreferences.PreferenceException e) {
            LOGGER.error("Failed to set user preferences for {}", (Object)key, (Object)e);
        }
    }

    @Override
    public void remove(String key, ConfluenceUser user) {
        try {
            this.userAccessor.getUserPreferences(user).remove("efi.store.onboarding." + key);
        }
        catch (UserPreferences.PreferenceException e) {
            LOGGER.error("Failed to remove user preferences for {}", (Object)key, (Object)e);
        }
    }
}

