/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.model;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import java.text.DecimalFormat;

final class CacheStatisticsHelper {
    private final FormatSettingsManager formatSettingsManager;
    private final I18NBean i18nBean;

    CacheStatisticsHelper(FormatSettingsManager formatSettingsManager, I18NBean i18nBean) {
        this.formatSettingsManager = formatSettingsManager;
        this.i18nBean = i18nBean;
    }

    String formatSizeInMegabytes(long localHeapSizeInBytes) {
        float sizeInMB = (float)localHeapSizeInBytes / 1024.0f / 1024.0f;
        if (sizeInMB > 0.0f && sizeInMB < 1.0f) {
            return "<1";
        }
        DecimalFormat format = new DecimalFormat(this.formatSettingsManager.getLongNumberFormat());
        return format.format((long)sizeInMB);
    }

    String getDisplayableName(String cacheName) {
        String i18nValue;
        String i18nKey = "cache.name." + cacheName.replace("_v5", "");
        return i18nKey.equals(i18nValue = this.i18nBean.getText(i18nKey)) ? cacheName : i18nValue;
    }

    static int asPercentage(long numerator, long denominator) {
        return denominator > 0L ? (int)((double)numerator / (double)denominator * 100.0) : 0;
    }

    static int calculateCapacityPercentage(long currentSize, long maxSize) {
        return (int)((float)currentSize / (float)maxSize * 100.0f);
    }
}

