/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.cache.CacheConfigManager;
import com.atlassian.confluence.cache.rest.events.AllCachesFlushEvent;
import com.atlassian.confluence.cache.rest.events.CacheManagementForbiddenEvent;
import com.atlassian.confluence.cache.rest.events.SingleCacheFlushEvent;
import com.atlassian.confluence.cache.rest.events.UpdateCacheConfigEvent;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyAccessAllowed
@Path(value="/")
public class CacheManagementResource {
    private static final Logger log = LoggerFactory.getLogger(CacheManagementResource.class);
    private final PermissionManager permissionManager;
    private final CacheConfigManager cacheConfigManager;
    private final CacheManager cacheManager;
    private final EventPublisher eventPublisher;

    @Inject
    public CacheManagementResource(@ComponentImport PermissionManager permissionManager, @ComponentImport CacheConfigManager cacheConfigManager, @ComponentImport CacheManager cacheManager, @ComponentImport EventPublisher eventPublisher) {
        this.permissionManager = permissionManager;
        this.cacheConfigManager = cacheConfigManager;
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
    }

    @Path(value="/cacheEntries")
    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    public void flushCache(@QueryParam(value="cacheName") Optional<String> cacheName) {
        if (cacheName.isPresent()) {
            log.warn("Flushing cache '{}'", cacheName);
            this.eventPublisher.publish((Object)new SingleCacheFlushEvent(cacheName.get()));
            this.cacheManager.getCache(cacheName.get()).removeAll();
        } else {
            log.warn("Flushing all caches");
            this.eventPublisher.publish((Object)new AllCachesFlushEvent());
            this.cacheManager.flushCaches();
        }
    }

    @Path(value="/cacheConfig")
    @POST
    public void updateCacheConfig(@FormParam(value="cacheName") String cacheName, @FormParam(value="maxElements") int maxElements) {
        log.warn("Requested to change max size of cache [{}] to [{}]", (Object)cacheName, (Object)maxElements);
        this.assertIsAdmin();
        if (maxElements <= 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.eventPublisher.publish((Object)new UpdateCacheConfigEvent(cacheName));
        log.warn("Changing max size of cache [{}] to [{}]", (Object)cacheName, (Object)maxElements);
        this.cacheConfigManager.changeMaxCacheSize(cacheName, maxElements);
    }

    private void assertIsAdmin() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator(user)) {
            this.eventPublisher.publish((Object)new CacheManagementForbiddenEvent());
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }
}

