/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.crowd.directory;

import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.impl.crowd.directory.CacheableDirectoryInstanceLoader;
import com.atlassian.crowd.azure.AzureFilteringEnabledChecker;
import com.atlassian.crowd.core.event.MultiEventPublisher;
import com.atlassian.crowd.darkfeature.CrowdDarkFeatureManager;
import com.atlassian.crowd.directory.TransactionalDirectoryCacheFactory;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresherFactory;
import com.atlassian.crowd.directory.ldap.cache.CrowdServerCacheRefresherFactory;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCacheFactory;
import com.atlassian.crowd.directory.loader.AzureAdDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.AzureAdDirectoryInstanceLoaderImpl;
import com.atlassian.crowd.directory.loader.CustomDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatedAuthenticationDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatedAuthenticationDirectoryInstanceLoaderImpl;
import com.atlassian.crowd.directory.loader.DelegatingDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatingDirectoryInstanceLoaderImpl;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalDirectoryInstanceLoaderImpl;
import com.atlassian.crowd.directory.loader.LDAPDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.LDAPDirectoryInstanceLoaderImpl;
import com.atlassian.crowd.directory.loader.RemoteCrowdDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.RemoteCrowdDirectoryInstanceLoaderImpl;
import com.atlassian.crowd.directory.synchronisation.cache.AzureFilteringEnabledCheckerImpl;
import com.atlassian.crowd.embedded.spi.DcLicenseChecker;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.manager.audit.AuditService;
import com.atlassian.crowd.manager.audit.mapper.AuditLogGroupMapper;
import com.atlassian.crowd.manager.audit.mapper.AuditLogUserMapper;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.manager.recovery.RecoveryModeDirectoryLoader;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import jakarta.annotation.Resource;
import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
class CrowdDirectoryInstanceLoaderContextConfig {
    @Resource
    private EventPublisher eventPublisher;
    @Resource
    private CacheFactory cacheManager;
    @Resource
    private InstanceFactory instanceFactory;
    @Resource
    private DirectoryDao embeddedCrowdDirectoryDao;
    @Resource
    private UserDao embeddedCrowdUserDao;
    @Resource
    private GroupDao embeddedCrowdGroupDao;
    @Resource
    private SynchronisationStatusManager synchronisationStatusManager;
    @Resource
    private MultiEventPublisher crowdMultiEventPublisher5;
    @Resource
    private TransactionInterceptor crowdTransactionInterceptor;
    @Resource
    private AuditService crowdAuditService;
    @Resource
    private AuditLogUserMapper crowdAuditLogUserMapper;
    @Resource
    private AuditLogGroupMapper crowdAuditLogGroupMapper;
    @Resource
    private CrowdDarkFeatureManager crowdDarkFeatureManager;
    @Resource(name="defaultLicenseService")
    private DcLicenseChecker licenseService;

    CrowdDirectoryInstanceLoaderContextConfig() {
    }

    @Bean
    @AvailableToPlugins
    DirectoryInstanceLoader directoryInstanceLoader() {
        return new CacheableDirectoryInstanceLoader((DelegatingDirectoryInstanceLoader)new DelegatingDirectoryInstanceLoaderImpl(Arrays.asList(new RecoveryModeDirectoryLoader(), this.crowdInternalDirectoryLoader(), this.delegatedAuthenticationDirectoryInstanceLoader(), this.crowdDatabaseCachingDirectoryLoader(), this.customDirectoryLoader())), (EventListenerRegistrar)this.eventPublisher, this.cacheManager);
    }

    @Bean(autowireCandidate=false)
    DirectoryInstanceLoader customDirectoryLoader() {
        return new CustomDirectoryInstanceLoader(this.instanceFactory);
    }

    @Bean(autowireCandidate=false)
    DirectoryInstanceLoader crowdDatabaseCachingDirectoryLoader() {
        return new DbCachingRemoteDirectoryInstanceLoader((DirectoryInstanceLoader)new DelegatingDirectoryInstanceLoaderImpl(Arrays.asList(this.crowdLdapDirectoryLoader(), this.remoteCrowdDirectoryInstanceLoader(), this.azureAdDirectoryInstanceLoader())), this.crowdInternalDirectoryLoader(), this.crowdDirectoryCacheFactory(), (CacheRefresherFactory)new CrowdServerCacheRefresherFactory((AzureFilteringEnabledChecker)new AzureFilteringEnabledCheckerImpl(this.licenseService)), this.crowdAuditService, this.crowdAuditLogUserMapper, this.crowdAuditLogGroupMapper, this.eventPublisher, this.embeddedCrowdDirectoryDao);
    }

    @Bean
    DirectoryCacheFactory crowdDirectoryCacheFactory() {
        return new TransactionalDirectoryCacheFactory(this.embeddedCrowdDirectoryDao, this.synchronisationStatusManager, this.crowdMultiEventPublisher5, this.embeddedCrowdUserDao, this.embeddedCrowdGroupDao, this.crowdTransactionInterceptor, this.crowdDarkFeatureManager);
    }

    @Bean(autowireCandidate=false)
    RemoteCrowdDirectoryInstanceLoader remoteCrowdDirectoryInstanceLoader() {
        return new RemoteCrowdDirectoryInstanceLoaderImpl(this.instanceFactory);
    }

    @Bean(autowireCandidate=false)
    InternalDirectoryInstanceLoader crowdInternalDirectoryLoader() {
        return new InternalDirectoryInstanceLoaderImpl(this.instanceFactory);
    }

    @Bean(autowireCandidate=false)
    DelegatedAuthenticationDirectoryInstanceLoader delegatedAuthenticationDirectoryInstanceLoader() {
        return new DelegatedAuthenticationDirectoryInstanceLoaderImpl(this.crowdLdapDirectoryLoader(), this.crowdInternalDirectoryLoader(), this.eventPublisher, this.embeddedCrowdDirectoryDao);
    }

    @Bean(autowireCandidate=false)
    LDAPDirectoryInstanceLoader crowdLdapDirectoryLoader() {
        return new LDAPDirectoryInstanceLoaderImpl(this.instanceFactory);
    }

    @Bean(autowireCandidate=false)
    AzureAdDirectoryInstanceLoader azureAdDirectoryInstanceLoader() {
        return new AzureAdDirectoryInstanceLoaderImpl(this.instanceFactory);
    }
}

