/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.crowd.directory;

import com.atlassian.crowd.crypto.Algorithm;
import com.atlassian.crowd.crypto.DbConfigPasswordCipherEncryptorsFactory;
import com.atlassian.crowd.crypto.PrefixBasedSwitchableEncryptor;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.crowd.password.encoder.AtlassianSecurityPasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.password.factory.PasswordEncoderFactoryImpl;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class CrowdEncryptorContextConfig {
    private static final Set<String> ALGORITHMS = Set.of(Algorithm.AES.getKey());

    CrowdEncryptorContextConfig() {
    }

    @Bean
    Encryptor crowdEncryptor(EncryptionSettings encryptionSettings) {
        return new PrefixBasedSwitchableEncryptor(encryptionSettings, Maps.filterKeys((Map)DbConfigPasswordCipherEncryptorsFactory.createEncryptorsMap((EncryptionSettings)encryptionSettings), ALGORITHMS::contains));
    }

    @Bean
    @AvailableToPlugins
    PasswordEncoderFactory crowdPasswordEncoderFactory() {
        return new PasswordEncoderFactoryImpl(List.of(new AtlassianSecurityPasswordEncoder()));
    }
}

