/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.crowd.directory;

import com.atlassian.confluence.impl.crowd.directory.ConfluenceLdapDirectoryClearingClusterEventPublisher;
import com.atlassian.crowd.directory.LdapContextSourceFactory;
import com.atlassian.crowd.directory.LdapContextSourceProvider;
import com.atlassian.crowd.directory.LdapDirectoryClearingClusterEventPublisher;
import com.atlassian.crowd.directory.SpringLdapPooledContextSourceProvider;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapperImpl;
import com.atlassian.crowd.directory.ldap.connectionpool.DefaultSpringLdapPoolConfigService;
import com.atlassian.crowd.directory.ldap.connectionpool.SpringLdapPoolConfigService;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelperImpl;
import com.atlassian.crowd.directory.ldap.util.LdapConnectionPropertiesDiffResultMapper;
import com.atlassian.crowd.embedded.spi.DcLicenseChecker;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslaterImpl;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import jakarta.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class SpringLdapContextConfig {
    @Resource
    private EventPublisher eventPublisher;
    @Resource(name="licenseService")
    private DcLicenseChecker licenseChecker;

    SpringLdapContextConfig() {
    }

    @Bean
    @AvailableToPlugins
    SpringLdapPoolConfigService springLdapPoolConfigService() {
        return new DefaultSpringLdapPoolConfigService();
    }

    @Bean
    LdapConnectionPropertiesDiffResultMapper ldapConnectionPropertiesDiffResultMapper() {
        return new LdapConnectionPropertiesDiffResultMapper(this.springLdapPoolConfigService());
    }

    @Bean
    LdapContextSourceFactory ldapContextSourceFactory() {
        return new LdapContextSourceFactory(this.springLdapPoolConfigService());
    }

    @Bean
    SpringLdapPooledContextSourceProvider ldapPooledContextSourceProvider() {
        return new SpringLdapPooledContextSourceProvider(this.ldapContextSourceFactory(), this.eventPublisher, (LdapDirectoryClearingClusterEventPublisher)new ConfluenceLdapDirectoryClearingClusterEventPublisher(this.eventPublisher), this.ldapConnectionPropertiesDiffResultMapper());
    }

    @Bean
    LdapContextSourceProvider ldapContextSourceProvider() {
        return new LdapContextSourceProvider(this.ldapContextSourceFactory(), this.ldapPooledContextSourceProvider(), this.licenseChecker);
    }

    @Bean
    @AvailableToPlugins
    LDAPPropertiesMapper embeddedCrowdLdapPropertiesMapper() {
        return new LDAPPropertiesMapperImpl(this.crowdLdapPropertiesHelper());
    }

    @Bean
    LDAPPropertiesHelper crowdLdapPropertiesHelper() {
        return new LDAPPropertiesHelperImpl();
    }

    @Bean
    LDAPQueryTranslater crowdLdapQueryTranslator() {
        return new LDAPQueryTranslaterImpl();
    }
}

