/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.ContentRetrieverResult;
import com.atlassian.confluence.extra.masterdetail.MasterDetailConfigurator;
import com.atlassian.confluence.extra.masterdetail.analytics.DetailsSummaryMacroMetricsEvent;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ContentRetriever {
    private static final Logger logger = LoggerFactory.getLogger(ContentRetriever.class);
    private final CQLSearchService searchService;
    private final ContentEntityManager contentEntityManager;
    private final I18nResolver i18nResolver;
    private final Supplier<Integer> maxResultsSupplier;
    private final int BATCH_SIZE;

    @Autowired
    public ContentRetriever(@ComponentImport CQLSearchService searchService, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, @ComponentImport I18nResolver i18nResolver, MasterDetailConfigurator configurator) {
        this.searchService = searchService;
        this.i18nResolver = i18nResolver;
        this.contentEntityManager = contentEntityManager;
        this.maxResultsSupplier = configurator::getPagePropertiesReportContentRetrieverMaxResult;
        this.BATCH_SIZE = configurator.getPagePropertiesReportContentRetrieverBatchSize();
    }

    public void iterateThoughContentByCQL(String fullCql, SearchContext context, int batchSize, Consumer<ContentRetrieverResult> callback) throws MacroExecutionException {
        SearchContext searchContext = context == null ? SearchContext.builder().contentStatus(Collections.singletonList(ContentStatus.CURRENT)).build() : context;
        int MAX_RESULTS = this.maxResultsSupplier.get();
        try {
            boolean hasMoreContent = true;
            int startIndex = 0;
            int nextLimit = startIndex + batchSize;
            while (hasMoreContent && nextLimit <= MAX_RESULTS) {
                SimplePageRequest nextBatchPageRequest = new SimplePageRequest(startIndex, batchSize);
                PageResponse contents = this.searchService.searchContent(fullCql, searchContext, (PageRequest)nextBatchPageRequest, new Expansion[0]);
                hasMoreContent = contents.hasMore();
                nextLimit = (startIndex += contents.size()) + batchSize;
                try {
                    List<ContentEntityObject> contentList = this.transformToCEO(contents.getResults());
                    callback.accept(new ContentRetrieverResult(contentList, nextLimit >= MAX_RESULTS && hasMoreContent));
                }
                catch (Exception e) {
                    logger.error("Retrieving contents for Page Property Report has failed:", (Throwable)e);
                }
            }
            if (nextLimit > MAX_RESULTS) {
                logger.warn("Reaching hard limit of ContentRetriever will skip the rest of remaining data");
            }
        }
        catch (ServiceException e) {
            String msg = this.i18nResolver.getText("detailssummary.error.searchservice.exception", new Serializable[]{fullCql, e.getMessage()});
            throw new MacroExecutionException(msg, (Throwable)e);
        }
    }

    public ContentRetrieverResult getContentWithMetaData(@Nonnull String cql, boolean reverseSort, SearchContext searchContext, DetailsSummaryMacroMetricsEvent.Builder metrics) throws MacroExecutionException {
        metrics.maxResultConfig(this.maxResultsSupplier.get());
        ArrayList results = Lists.newArrayList();
        Boolean[] rowsLimited = new Boolean[]{false};
        String fullCql = "(" + cql + ") and macro = details" + this.buildOrderByClause(reverseSort);
        metrics.contentSearchStart();
        this.iterateThoughContentByCQL(fullCql, searchContext, this.BATCH_SIZE, listContent -> {
            results.addAll(listContent.getRows());
            rowsLimited[0] = listContent.isLimited();
        });
        metrics.contentSearchFinish();
        metrics.labelledContentCount(results.size());
        return new ContentRetrieverResult(results, rowsLimited[0]);
    }

    private String buildOrderByClause(boolean reverseSort) {
        Object order = " order by lastModified";
        if (!reverseSort) {
            order = (String)order + " desc";
        }
        return order;
    }

    private List<ContentEntityObject> transformToCEO(List<Content> results) {
        return results.stream().map(content -> {
            if ("comment".equals(content.getType().getType())) {
                return this.contentEntityManager.getById(content.getId().asLong());
            }
            return new IdOnlyCEO((Content)content);
        }).collect(Collectors.toList());
    }

    public static class IdOnlyCEO
    extends AbstractPage {
        private final Content content;
        private String urlPath;

        public IdOnlyCEO(Content content) {
            this.content = content;
            this.setId(content.getId().asLong());
            this.setTitle(content.getTitle());
            this.setSpace(new Space(com.atlassian.confluence.api.model.content.Space.getSpaceKey((Reference)content.getSpaceRef())));
        }

        public void setUrlPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public String getUrlPath() {
            if (StringUtils.isNotEmpty((CharSequence)this.urlPath)) {
                return this.urlPath;
            }
            return super.getUrlPath();
        }

        public String getType() {
            return this.content.getType().getType();
        }

        public String getNameForComparison() {
            throw new UnsupportedOperationException();
        }

        public String getLinkWikiMarkup() {
            throw new UnsupportedOperationException();
        }
    }
}

