/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail.cqlmigrator;

import com.atlassian.confluence.extra.masterdetail.cqlmigrator.EmptyQueryExpression;
import com.atlassian.confluence.extra.masterdetail.cqlmigrator.QueryExpression;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class CompositeQueryExpression
implements QueryExpression {
    private final BooleanOperator operator;
    private final List<QueryExpression> expressions;

    private CompositeQueryExpression(BooleanOperator operator, List<? extends QueryExpression> expressions) {
        this.operator = operator;
        this.expressions = ImmutableList.copyOf(expressions);
    }

    @Override
    public String toQueryString() {
        if (this.expressions.isEmpty()) {
            return "";
        }
        if (this.expressions.size() > 1) {
            return Joiner.on((String)this.operator.toString()).join((Iterable)Lists.transform(this.expressions, QueryExpression::toQueryString));
        }
        return this.expressions.get(0).toQueryString();
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    public BooleanOperator getOperator() {
        return this.operator;
    }

    public QueryExpression get(int i) {
        return this.expressions.get(i);
    }

    public int size() {
        return this.expressions.size();
    }

    public static Builder builder(BooleanOperator operator) {
        return new Builder(operator);
    }

    public static enum BooleanOperator {
        AND(" and "),
        OR(" or ");

        private final String str;

        private BooleanOperator(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static class Builder {
        private BooleanOperator operator;
        private List<QueryExpression> expressions = Lists.newArrayList();

        private Builder(BooleanOperator operator) {
            this.operator = operator;
        }

        public Builder add(QueryExpression expression) {
            if (expression != null && !(expression instanceof EmptyQueryExpression)) {
                this.expressions.add(expression);
            }
            return this;
        }

        public QueryExpression build() {
            if (this.expressions.isEmpty()) {
                return EmptyQueryExpression.EMPTY;
            }
            if (this.expressions.size() == 1) {
                return this.expressions.get(0);
            }
            return new CompositeQueryExpression(this.operator, this.expressions);
        }
    }
}

