/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.ContentRetriever;
import com.atlassian.confluence.extra.masterdetail.ContentRetrieverResult;
import com.atlassian.confluence.extra.masterdetail.DetailsSummaryBuilder;
import com.atlassian.confluence.extra.masterdetail.DetailsSummaryParameters;
import com.atlassian.confluence.extra.masterdetail.analytics.DetailsSummaryMacroMetricsEvent;
import com.atlassian.confluence.extra.masterdetail.entities.PaginatedDetailLines;
import com.atlassian.confluence.extra.masterdetail.rest.DetailsSummaryLines;
import com.atlassian.confluence.extra.masterdetail.rest.ResourceErrorType;
import com.atlassian.confluence.extra.masterdetail.rest.ResourceException;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.renderer.RenderContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="detailssummary")
public class DetailsSummaryResource {
    private final DetailsSummaryBuilder detailsSummaryBuilder;
    private final ContentRetriever contentRetriever;
    private final EventPublisher eventPublisher;
    private final ContentEntityManager contentEntityManager;

    @Inject
    public DetailsSummaryResource(@ComponentImport EventPublisher eventPublisher, @ComponentImport @Named(value="contentEntityManager") ContentEntityManager contentEntityManager, ContentRetriever contentRetriever, DetailsSummaryBuilder detailsSummaryBuilder) {
        this.eventPublisher = eventPublisher;
        this.contentEntityManager = contentEntityManager;
        this.contentRetriever = contentRetriever;
        this.detailsSummaryBuilder = detailsSummaryBuilder;
    }

    @GET
    @Path(value="lines")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public DetailsSummaryLines getDetailLines(@QueryParam(value="cql") String cql, @QueryParam(value="detailsId") String detailsId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="reverseSort") @DefaultValue(value="false") boolean reverseSort, @QueryParam(value="spaceKey") String contextSpaceKey, @QueryParam(value="contentId") ContentId contentId, @QueryParam(value="pageSize") @DefaultValue(value="30") int pageSize, @QueryParam(value="pageIndex") @DefaultValue(value="0") int currentPage, @QueryParam(value="countComments") @DefaultValue(value="false") boolean countComments, @QueryParam(value="countLikes") @DefaultValue(value="false") boolean countLikes, @QueryParam(value="headings") String headings) {
        if (StringUtils.isEmpty((CharSequence)contextSpaceKey)) {
            throw new ResourceException("'spaceKey' parameter is required", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_MISSING, (Object)"spaceKey");
        }
        if (pageSize <= 0) {
            throw new ResourceException("Requested page size is not valid", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_INVALID, (Object)"pageSize");
        }
        if (currentPage < 0) {
            throw new ResourceException("Requested page index is not valid", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_INVALID, (Object)"pageIndex");
        }
        try {
            DetailsSummaryMacroMetricsEvent.Builder metrics = DetailsSummaryMacroMetricsEvent.builder(DetailsSummaryMacroMetricsEvent.Type.REST_RESOURCE);
            SearchContext searchContext = SearchContext.builder().spaceKey(contextSpaceKey).contentId(contentId).build();
            ContentRetrieverResult contentRetrieverResult = this.contentRetriever.getContentWithMetaData(cql, reverseSort, searchContext, metrics);
            List<ContentEntityObject> content = contentRetrieverResult.getRows();
            DetailsSummaryParameters summaryParams = new DetailsSummaryParameters().setPageSize(pageSize).setCurrentPage(currentPage).setCountComments(countComments).setCountLikes(countLikes).setHeadingsString(headings).setSortBy(sortBy).setReverseSort(reverseSort).setContent(content).setId(detailsId);
            ContentEntityObject reportPageCEO = null;
            if (Objects.nonNull(contentId)) {
                reportPageCEO = this.contentEntityManager.getById(contentId.asLong());
            }
            DefaultConversionContext newConversionContext = new DefaultConversionContext((RenderContext)new PageContext(reportPageCEO), ConversionContextOutputType.DISPLAY.value());
            PaginatedDetailLines paginatedDetailLines = this.detailsSummaryBuilder.getPaginatedDetailLines(summaryParams, true, metrics, (ConversionContext)newConversionContext);
            this.eventPublisher.publish((Object)metrics.build());
            return new DetailsSummaryLines(summaryParams.getCurrentPage(), summaryParams.getTotalPages(), paginatedDetailLines.getRenderedHeadings(), paginatedDetailLines.getDetailLines(), paginatedDetailLines.isAsyncRenderSafe());
        }
        catch (MacroExecutionException e) {
            throw new ResourceException(e, Response.Status.INTERNAL_SERVER_ERROR, ResourceErrorType.RENDERING_MACRO);
        }
    }
}

