/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.namemapping;

import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.namemapping.NameMapping;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class ChangeLetterCaseNameMapping
implements NameMapping {
    private Locale locale;
    private final LetterCase targetCase;

    public ChangeLetterCaseNameMapping(LetterCase targetCase, Locale locale) {
        this.locale = Objects.requireNonNull(locale);
        this.targetCase = Objects.requireNonNull(targetCase);
    }

    @Override
    public Optional<String> getColumnOverride(SchemaAndTable key, String column) {
        return Optional.ofNullable(this.targetCaseOrNull(column));
    }

    @Override
    public Optional<SchemaAndTable> getOverride(SchemaAndTable key) {
        return Optional.of(new SchemaAndTable(this.targetCaseOrNull(key.getSchema()), this.targetCaseOrNull(key.getTable())));
    }

    private String targetCaseOrNull(String text) {
        if (this.targetCase == LetterCase.LOWER) {
            return text.toLowerCase(this.locale);
        }
        return text.toUpperCase(this.locale);
    }

    public static enum LetterCase {
        LOWER,
        UPPER;

    }
}

