/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.custom_apps.ui;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.plugins.custom_apps.security.authentication.LoginPage;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.WebResourceManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SystemAdminOnly
public class AdminServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AdminServlet.class);
    private final WebResourceManager webResourceManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final WebSudoManager webSudoManager;
    private final LoginPage loginPage;

    public AdminServlet(WebResourceManager webResourceManager, SoyTemplateRenderer soyTemplateRenderer, UserManager userManager, I18nResolver i18nResolver, WebSudoManager webSudoManager, LoginPage loginPage) {
        this.webResourceManager = webResourceManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
        this.webSudoManager = webSudoManager;
        this.loginPage = loginPage;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            if (!this.userManager.isAdmin(this.userManager.getRemoteUserKey(req))) {
                this.loginPage.redirect(req, resp);
            } else {
                this.webResourceManager.requireResource("com.atlassian.plugins.atlassian-nav-links-plugin:custom-apps-admin-ui-resources");
                resp.setContentType("text/html");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("title", this.i18nResolver.getText("custom-apps.page.title"));
                params.put("description", this.i18nResolver.getText("custom-apps.page.description"));
                params.put("loginRedirectUrl", this.loginPage.getRedirectUrl(req));
                try {
                    resp.getWriter().print(this.soyTemplateRenderer.render("com.atlassian.plugins.atlassian-nav-links-plugin:custom-apps-admin-page-template", "com.atlassian.plugins.custom_apps.ui.customAppsAdminPage", params));
                }
                catch (SoyException e) {
                    log.error("Error rendering template", (Throwable)e);
                    resp.sendError(500, e.getMessage());
                }
            }
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }
}

