/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.http;

import com.atlassian.plugins.navlink.consumer.http.CleaningUpResponseHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpRequest {
    private final HttpClient client;
    private final HttpGet request;

    public HttpRequest(@Nonnull HttpClient client, @Nonnull HttpGet request) {
        this.client = Objects.requireNonNull(client);
        this.request = Objects.requireNonNull(request);
    }

    @Nonnull
    public <T> T executeRequest(@Nonnull ResponseHandler<T> responseHandler) throws IOException {
        return (T)this.client.execute((HttpUriRequest)this.request, this.withCleanUpHandler(Objects.requireNonNull(responseHandler)));
    }

    private <T> ResponseHandler<T> withCleanUpHandler(@Nonnull ResponseHandler<T> responseHandler) {
        return new CleaningUpResponseHandler<T>(responseHandler);
    }
}

