/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.rest;

import com.atlassian.plugins.navlink.consumer.menu.rest.MenuNavigationLinkEntity;
import com.atlassian.plugins.navlink.consumer.menu.services.MenuService;
import com.atlassian.plugins.navlink.producer.navigation.NavigationLink;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;

@Path(value="/")
public class MenuResource {
    private final MenuService menuService;
    private final LocaleResolver localeResolver;
    private final UserManager userManager;

    @Inject
    public MenuResource(MenuService menuService, LocaleResolver localeResolver, UserManager userManager) {
        this.menuService = menuService;
        this.localeResolver = localeResolver;
        this.userManager = userManager;
    }

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    public Response getMenuByKey(@Context HttpServletRequest hsr, @PathParam(value="key") String key) {
        Iterable<NavigationLink> menuNavigationLinks = this.menuService.getMenuItems(key, this.userManager.getRemoteUsername(hsr), this.localeResolver.getLocale());
        return this.createMenuNavigationLinkResponse(menuNavigationLinks);
    }

    @GET
    @Path(value="appswitcher")
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    public Response getAppSwitcherMenu(@Context HttpServletRequest hsr) {
        Iterable<NavigationLink> menuNavigationLinks = this.menuService.getAppSwitcherItems(this.userManager.getRemoteUsername(hsr));
        return this.createMenuNavigationLinkResponse(menuNavigationLinks);
    }

    private Response createMenuNavigationLinkResponse(Iterable<NavigationLink> menuNavigationLinks) {
        List<MenuNavigationLinkEntity> menuEntities = StreamSupport.stream(menuNavigationLinks.spliterator(), false).map(this::convertToEntities).toList();
        return Response.ok(menuEntities).build();
    }

    private MenuNavigationLinkEntity convertToEntities(NavigationLink menuNavigationLink) {
        return menuNavigationLink != null ? new MenuNavigationLinkEntity(menuNavigationLink) : null;
    }

    @PUT
    @Path(value="userdata")
    @Produces(value={"application/json"})
    @LicensedOnly
    public Response setUserData(@Context HttpServletRequest hsr, StorageBean storageBean) {
        this.menuService.setUserData(storageBean.key, storageBean.value);
        return Response.ok((Object)storageBean).build();
    }

    @GET
    @Path(value="userdata")
    @Produces(value={"application/json"})
    @LicensedOnly
    public Response getUserData(@Context HttpServletRequest hsr, @QueryParam(value="key") String key) {
        return Response.ok((Object)new StorageBean(key, this.menuService.getUserData(key))).build();
    }

    private CacheControl cacheFor(int duration, TimeUnit unit, boolean isPrivate) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge((int)unit.toSeconds(duration));
        cacheControl.setPrivate(isPrivate);
        return cacheControl;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class StorageBean {
        @JsonProperty
        String key;
        @JsonProperty
        String value;

        public StorageBean() {
        }

        public StorageBean(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

