/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.ExpiringValue;
import com.atlassian.plugins.navlink.consumer.menu.client.capabilities.CapabilitiesClient;
import com.atlassian.plugins.navlink.consumer.menu.services.IgnoreRemotePluginNavigationPredicate;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.google.common.util.concurrent.Futures;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CapabilitiesCacheLoader
implements CacheLoader<ApplicationId, RemoteApplicationWithCapabilities> {
    private final ReadOnlyApplicationLinkService readOnlyApplicationLinkService;
    private final ApplicationLinkService applicationLinkService;
    private final CapabilitiesClient capabilitiesClient;

    public CapabilitiesCacheLoader(ReadOnlyApplicationLinkService readOnlyApplicationLinkService, ApplicationLinkService applicationLinkService, CapabilitiesClient capabilitiesClient) {
        this.readOnlyApplicationLinkService = readOnlyApplicationLinkService;
        this.applicationLinkService = applicationLinkService;
        this.capabilitiesClient = capabilitiesClient;
    }

    public Set<ApplicationId> getAllKeys() {
        return StreamSupport.stream(this.readOnlyApplicationLinkService.getApplicationLinks().spliterator(), false).filter(new IgnoreRemotePluginNavigationPredicate(this.applicationLinkService).negate()).map(this::toApplicationId).collect(Collectors.toUnmodifiableSet());
    }

    public Future<ExpiringValue<RemoteApplicationWithCapabilities>> loadValueFuture(ApplicationId applicationId) {
        try {
            ReadOnlyApplicationLink applicationLink = this.getApplicationLink(applicationId);
            return this.capabilitiesClient.getCapabilities(applicationLink);
        }
        catch (RuntimeException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        catch (TypeNotInstalledException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private ReadOnlyApplicationLink getApplicationLink(ApplicationId applicationId) throws TypeNotInstalledException {
        return Objects.requireNonNull(this.readOnlyApplicationLinkService.getApplicationLink(applicationId), "Application link with application id '" + String.valueOf(applicationId) + "' is not existing.");
    }

    private ApplicationId toApplicationId(ReadOnlyApplicationLink from) {
        return from != null ? from.getId() : null;
    }
}

