/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.capabilities.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.navlink.producer.capabilities.ApplicationWithCapabilities;
import com.atlassian.plugins.navlink.producer.capabilities.services.CapabilityService;
import com.atlassian.plugins.navlink.util.CacheControlFactory;
import com.atlassian.plugins.navlink.util.LastModifiedFormatter;
import com.atlassian.plugins.navlink.util.date.UniversalDateFormatter;
import com.atlassian.plugins.navlink.util.url.BaseUrl;
import com.atlassian.plugins.navlink.util.url.SelfUrl;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class CapabilitiesServlet
extends HttpServlet {
    private static final String TEMPLATE = "com.atlassian.plugins.navlink.capabilities";
    private final Logger logger = LoggerFactory.getLogger(CapabilitiesServlet.class);
    private final CapabilityService capabilityService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ApplicationProperties applicationProperties;

    public CapabilitiesServlet(CapabilityService capabilityService, SoyTemplateRenderer soyTemplateRenderer, ApplicationProperties applicationProperties) {
        this.capabilityService = capabilityService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.applicationProperties = applicationProperties;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            httpServletResponse.setHeader("Cache-Control", CacheControlFactory.withConfiguredMaxAgeAndStaleContentExtension().toString());
            httpServletResponse.setHeader("Last-Modified", LastModifiedFormatter.formatCurrentTimeMillis());
            Map<String, Object> context = this.createContext(httpServletRequest);
            PrintWriter writer = httpServletResponse.getWriter();
            this.renderTemplate(context, writer);
        }
        catch (IOException e) {
            this.handleException(httpServletResponse, e);
        }
    }

    private void renderTemplate(Map<String, Object> context, Writer writer) throws IOException {
        this.soyTemplateRenderer.render((Appendable)writer, "com.atlassian.plugins.atlassian-nav-links-plugin:capabilities-resources", TEMPLATE, context);
    }

    private Map<String, Object> createContext(HttpServletRequest httpServletRequest) {
        BaseUrl baseUrl = new BaseUrl(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        String selfUrl = SelfUrl.extractFrom(httpServletRequest);
        ApplicationWithCapabilities hostApplication = this.capabilityService.getHostApplication();
        Map<String, String> capabilities = hostApplication.getAllCapabilities().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> baseUrl.resolve((String)entry.getValue())));
        return Map.of("selfUrl", baseUrl.resolve(selfUrl), "buildDate", this.formatBuildDate(), "hostApplicationType", hostApplication.getType(), "capabilities", capabilities);
    }

    private void handleException(HttpServletResponse httpServletResponse, Exception e) {
        this.logger.warn("Failed to serialize application capabilities: {}", (Object)e.getMessage());
        this.logger.debug("Stacktrace:", (Throwable)e);
        httpServletResponse.setStatus(500);
    }

    private String formatBuildDate() {
        Date buildDate = this.applicationProperties.getBuildDate();
        return UniversalDateFormatter.formatUtc(buildDate.toInstant().atZone(ZoneOffset.UTC));
    }
}

