/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.pagetree;

import com.atlassian.confluence.content.ContentQuery;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.pagetree.PageTreeMappings;
import com.atlassian.confluence.search.v2.extractor.BulkExtractor;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class PageHierarchyBulkExtractor
implements BulkExtractor<ContentEntityObject> {
    static final int UNSPECIFIED_POSITION = -1;
    private final CustomContentManager customContentManager;

    public PageHierarchyBulkExtractor(CustomContentManager customContentManager) {
        this.customContentManager = Objects.requireNonNull(customContentManager);
    }

    public boolean canHandle(@Nonnull Class<?> entityType) {
        return Page.class.isAssignableFrom(entityType) || Attachment.class.isAssignableFrom(entityType);
    }

    public void extractAll(@Nonnull Collection<ContentEntityObject> searchables, @Nonnull Class<? extends ContentEntityObject> entityType, @Nonnull BiConsumer<ContentEntityObject, FieldDescriptor> sink) {
        Map<Long, List<ContentEntityObject>> searchablesByPageId = this.mapByContainingPageId(searchables);
        if (searchablesByPageId.isEmpty()) {
            return;
        }
        Collection<Page> pages = this.queryForPages(searchablesByPageId.keySet());
        searchablesByPageId.forEach((pageId, searchableList) -> pages.stream().filter(page -> Objects.equals(page.getId(), pageId)).findFirst().ifPresent(page -> searchableList.forEach(searchable -> this.extractFields((Page)page, (ContentEntityObject)searchable, sink))));
    }

    private Map<Long, List<ContentEntityObject>> mapByContainingPageId(Collection<ContentEntityObject> searchables) {
        return searchables.stream().filter(searchable -> PageHierarchyBulkExtractor.getContainingPageId(searchable).isPresent()).collect(Collectors.groupingBy(searchable -> PageHierarchyBulkExtractor.getContainingPageId(searchable).get(), Collectors.toList()));
    }

    private Collection<Page> queryForPages(Collection<Long> pageIds) {
        ContentQuery contentQuery = new ContentQuery("pagetree.bulkQueryPageAncestors", pageIds.toArray(new Object[0]));
        return this.customContentManager.queryForList(contentQuery);
    }

    private void extractFields(Page page, ContentEntityObject searchable, BiConsumer<ContentEntityObject, FieldDescriptor> sink) {
        Stream.concat(Stream.of(page), page.getAncestors().stream()).map(this::createAncestorField).forEach(field -> sink.accept(searchable, (FieldDescriptor)field));
        if (searchable instanceof Page) {
            sink.accept(searchable, this.createPositionField(page));
        }
    }

    private FieldDescriptor createAncestorField(Page page) {
        return PageTreeMappings.ANCESTORS_KEY.createField(String.valueOf(page.getId()));
    }

    private FieldDescriptor createPositionField(Page page) {
        int position = Optional.ofNullable(page.getPosition()).orElse(-1);
        return PageTreeMappings.POSITION_KEY.createField(String.valueOf(position));
    }

    private static Optional<Long> getContainingPageId(ContentEntityObject searchable) {
        Attachment attachment;
        ContentEntityObject container;
        if (searchable instanceof Page) {
            return Optional.of(searchable.getId());
        }
        if (searchable instanceof Attachment && (container = (attachment = (Attachment)searchable).getContainer()) instanceof Page) {
            return Optional.of(container.getId());
        }
        return Optional.empty();
    }
}

