/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.pagetree;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AnonymousSiteAccess
public class PageTreeSearchAction
extends ConfluenceActionSupport {
    private String queryString;
    private String ancestorId;
    private String searchActionString;
    private String spaceKey;

    public String execute() {
        StringBuilder actionString = new StringBuilder("/dosearchsite.action?searchQuery.queryString=");
        ArrayList<Object> searchTerms = new ArrayList<Object>();
        if (this.ancestorId != null && !this.ancestorId.isEmpty()) {
            searchTerms.add("ancestorIds%3A" + this.ancestorId);
        }
        if (this.queryString != null && !this.queryString.isEmpty()) {
            searchTerms.add(HtmlUtil.urlEncode((String)this.queryString, (Charset)GeneralUtil.getDefaultCharset()));
        }
        Iterator iter = searchTerms.iterator();
        while (iter.hasNext()) {
            String searchTerm = (String)iter.next();
            actionString.append(searchTerm);
            if (!iter.hasNext()) continue;
            actionString.append("+AND+");
        }
        actionString.append("&searchQuery.spaceKey=");
        if (StringUtils.isNotEmpty((CharSequence)this.spaceKey)) {
            actionString.append(HtmlUtil.urlEncode((String)this.spaceKey, (Charset)GeneralUtil.getDefaultCharset()));
        } else {
            actionString.append(HtmlUtil.urlEncode((String)"conf_all", (Charset)GeneralUtil.getDefaultCharset()));
        }
        this.searchActionString = actionString.toString();
        return "search";
    }

    public String getAncestorId() {
        return this.ancestorId;
    }

    @StrutsParameter
    public void setAncestorId(String ancestorId) {
        this.ancestorId = ancestorId;
    }

    public String getQueryString() {
        return this.queryString;
    }

    @StrutsParameter
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getSearchActionString() {
        return this.searchActionString;
    }

    @StrutsParameter
    public void setSearchActionString(String searchActionString) {
        this.searchActionString = searchActionString;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    @StrutsParameter
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }
}

