/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.util.FileAllowlistHelper;
import org.apache.velocity.runtime.resource.loader.util.FileTypeAllowlistHelper;
import org.apache.velocity.runtime.util.ConfigUtil;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.ExceptionUtils;

public class ClasspathResourceLoader
extends ResourceLoader {
    private FileAllowlistHelper fileAllowlistHelper = null;
    private FileTypeAllowlistHelper fileTypeAllowlistHelper = null;
    private List<String> trustedResourceProtocols = null;

    @Override
    public void init(ExtendedProperties configuration) {
        this.fileAllowlistHelper = new FileAllowlistHelper(this.rsvc);
        this.fileTypeAllowlistHelper = new FileTypeAllowlistHelper(this.rsvc, "classpath.resource.loader.filetype.allowlist");
        this.trustedResourceProtocols = ConfigUtil.getStrings(this.rsvc, "resource.loader.trusted.protocols");
        if (this.log.isTraceEnabled()) {
            this.log.trace("ClasspathResourceLoader : initialization complete.");
        }
    }

    @Override
    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream result = null;
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        try {
            URL resourceUrl = ClassUtils.getResource(this.getClass(), name);
            if (!this.trustedResourceProtocols.contains(resourceUrl.getProtocol())) {
                if (!this.fileTypeAllowlistHelper.isValidFileType(name)) {
                    throw new ResourceNotFoundException("ClasspathResourceLoader : banned file type on template " + name);
                }
                if (!this.fileAllowlistHelper.isAllowed(name)) {
                    throw new ResourceNotFoundException("FileResourceLoader : This template is not allowed: " + name);
                }
            }
            result = ClassUtils.getResourceAsStream(this.getClass(), name);
        }
        catch (Exception fnfe) {
            throw (ResourceNotFoundException)ExceptionUtils.createWithCause(ResourceNotFoundException.class, "problem with template: " + name, fnfe);
        }
        if (result == null) {
            String msg = "ClasspathResourceLoader Error: cannot find resource " + name;
            throw new ResourceNotFoundException(msg);
        }
        return result;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return false;
    }

    @Override
    public long getLastModified(Resource resource) {
        return 0L;
    }
}

