/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader.util;

import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.util.ConfigUtil;

public class FileAllowlistHelper {
    private static final Pattern LEADING_SLASHES = Pattern.compile("^/+");
    private final Set<String> allowedFilenames;
    private final boolean enabled;

    public FileAllowlistHelper(RuntimeServices runtimeServices) {
        Objects.requireNonNull(runtimeServices, "runtimeServices");
        this.allowedFilenames = ConfigUtil.getStrings(runtimeServices, "resource.loader.file.allowlist").stream().map(FileAllowlistHelper::stripLeadingForwardSlashes).filter(Objects::nonNull).filter(filename -> !filename.isEmpty()).collect(Collectors.toSet());
        this.enabled = runtimeServices.getBoolean("resource.loader.file.allowlist.enabled", false);
    }

    public boolean isAllowed(String templateName) {
        Objects.requireNonNull(templateName, "templateName");
        if (!this.enabled) {
            return true;
        }
        String strippedTemplateName = FileAllowlistHelper.stripLeadingForwardSlashes(templateName);
        return this.allowedFilenames.contains(strippedTemplateName);
    }

    private static String stripLeadingForwardSlashes(String string) {
        if (Objects.isNull(string)) {
            return null;
        }
        return LEADING_SLASHES.matcher(string).replaceAll("");
    }
}

