/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader.util;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.util.ConfigUtil;

public class FileTypeAllowlistHelper {
    private final List<String> lowercaseTrimmedAllowedFileTypes;
    private final boolean enabled;

    public FileTypeAllowlistHelper(RuntimeServices runtimeServices, String allowedFileTypesPropertyName) {
        Objects.requireNonNull(runtimeServices, "runtimeServices");
        Objects.requireNonNull(allowedFileTypesPropertyName, "allowedFileTypesPropertyName");
        this.lowercaseTrimmedAllowedFileTypes = ConfigUtil.getStrings(runtimeServices, allowedFileTypesPropertyName).stream().filter(extension -> {
            if (!extension.startsWith(".")) {
                throw new RuntimeException("Allowed Velocity file extension must start with '.' instead got: " + extension);
            }
            return true;
        }).map(String::toLowerCase).collect(Collectors.toList());
        this.enabled = runtimeServices.getBoolean("resource.loader.filetype.allowlist.enabled", false);
    }

    public boolean isValidFileType(String templateName) {
        Objects.requireNonNull(templateName, "templateName");
        if (!this.enabled) {
            return true;
        }
        templateName = templateName.toLowerCase();
        return this.lowercaseTrimmedAllowedFileTypes.stream().anyMatch(templateName::endsWith);
    }
}

