/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.util;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.velocity.runtime.RuntimeServices;

public final class ConfigUtil {
    public static List<String> getStrings(RuntimeServices runtimeServices, String propertyName) {
        Objects.requireNonNull(runtimeServices, "runtimeServices");
        Objects.requireNonNull(propertyName, "propertyName");
        Object rawValue = runtimeServices.getProperty(propertyName);
        if (Objects.isNull(rawValue)) {
            return Collections.emptyList();
        }
        if (rawValue instanceof String) {
            return Collections.singletonList(((String)rawValue).trim());
        }
        if (rawValue instanceof List) {
            return ((List)rawValue).stream().map(Object::toString).map(String::trim).collect(Collectors.toList());
        }
        throw new RuntimeException("Velocity property was not a string nor a list: " + propertyName);
    }
}

