/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.FilesystemUtils;
import org.apache.velocity.util.LazyRef;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.MethodTranslator;
import org.apache.velocity.util.introspection.MethodTranslatorImpl;
import org.apache.velocity.util.introspection.SecureIntrospectorControl;

public class SecureIntrospectorImpl
extends Introspector
implements SecureIntrospectorControl {
    private final MethodTranslator methodTranslator;
    private final boolean isSilentValidation;
    private final Supplier<Set<String>> restrictedClassesRef;
    private final Set<String> restrictedPackages;
    private final Supplier<Set<Class<?>>> restrictedPackagesExemptClassesRef;
    private final Set<String> restrictedPackagesExemptClasses;
    private final Set<String> restrictedPackagesExemptPackages;
    private final boolean isAllowlistEnabled;
    private final boolean isAllowlistDebugMode;
    private final Supplier<Map<Class<?>, Set<String>>> allowlistedMethodsRef;
    private final Supplier<Set<Class<?>>> allowlistedClassesRef;
    private final Set<String> allowlistedPackages;
    private final Set<String> parameterFilteringExemptMethodNames;
    private final Map<Class<?>, Boolean> restrictedClassCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Method, Boolean> allowlistedMethodCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<?>, Boolean> allowlistedClassCache = Collections.synchronizedMap(new WeakHashMap());

    private SecureIntrospectorImpl(boolean isSilentValidation, String[] restrictedClasses, String[] restrictedPackages, String[] restrictedPackagesExemptClasses, boolean isExemptClassValidationDisabled, String[] restrictedPackagesExemptPackages, boolean isAllowlistEnabled, boolean isAllowlistDebugMode, String[] allowlistedMethods, String[] allowlistedClasses, String[] allowlistedPackages, String[] parameterFilteringExemptMethodNames, String methodTranslatorImpl, Log log, RuntimeServices runtimeServices) {
        super(log, runtimeServices);
        this.isSilentValidation = isSilentValidation;
        this.restrictedClassesRef = new LazyRef<Set>(() -> this.toValidatedClassSet(restrictedClasses));
        this.restrictedPackages = SecureIntrospectorImpl.toParsedSet(restrictedPackages);
        if (isExemptClassValidationDisabled) {
            this.restrictedPackagesExemptClassesRef = Collections::emptySet;
            this.restrictedPackagesExemptClasses = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(restrictedPackagesExemptClasses)));
        } else {
            this.restrictedPackagesExemptClassesRef = new LazyRef<Set>(() -> this.toClassSet(restrictedPackagesExemptClasses));
            this.restrictedPackagesExemptClasses = Collections.emptySet();
        }
        this.restrictedPackagesExemptPackages = SecureIntrospectorImpl.toParsedSet(restrictedPackagesExemptPackages);
        this.isAllowlistEnabled = isAllowlistEnabled;
        this.isAllowlistDebugMode = isAllowlistDebugMode;
        this.parameterFilteringExemptMethodNames = SecureIntrospectorImpl.toParsedSet(parameterFilteringExemptMethodNames);
        this.allowlistedMethodsRef = new LazyRef<Map>(() -> this.toMethodSet(allowlistedMethods));
        this.allowlistedClassesRef = new LazyRef<Set>(() -> this.toClassSet(allowlistedClasses));
        this.allowlistedPackages = SecureIntrospectorImpl.toParsedSet(allowlistedPackages);
        this.methodTranslator = ClassUtils.getNewInstance(methodTranslatorImpl, MethodTranslator.class, new Object[0]);
    }

    public SecureIntrospectorImpl(Log log, RuntimeServices runtimeServices) {
        this(runtimeServices.getConfiguration().getBoolean("introspector.validation.silent.enable", false), runtimeServices.getConfiguration().getStringArray("introspector.restrict.classes"), runtimeServices.getConfiguration().getStringArray("introspector.restrict.packages"), (String[])ArrayUtils.addAll((Object[])runtimeServices.getConfiguration().getStringArray("introspector.allowlist.classes"), (Object[])runtimeServices.getConfiguration().getStringArray("introspector.allow.classes")), runtimeServices.getConfiguration().getBoolean("introspector.validate.exemptions.disable", false), runtimeServices.getConfiguration().getStringArray("introspector.allow.packages"), runtimeServices.getConfiguration().getBoolean("introspector.proper.allowlist.enable", false), runtimeServices.getConfiguration().getBoolean("introspector.proper.allowlist.debug.enable", false), runtimeServices.getConfiguration().getStringArray("introspector.proper.allowlist.methods"), runtimeServices.getConfiguration().getStringArray("introspector.proper.allowlist.classes"), runtimeServices.getConfiguration().getStringArray("introspector.proper.allowlist.packages"), runtimeServices.getConfiguration().getStringArray("introspector.allowlist.methods"), runtimeServices.getConfiguration().getString("introspector.method.translator", MethodTranslatorImpl.class.getName()), log, runtimeServices);
    }

    @Deprecated
    public SecureIntrospectorImpl(String[] restrictedClasses, String[] restrictedPackages, String[] restrictedPackagesExemptClasses, String[] parameterFilteringExemptMethodNames, Log log, RuntimeServices runtimeServices) {
        this(runtimeServices.getConfiguration().getBoolean("introspector.validation.silent.enable", false), restrictedClasses, restrictedPackages, restrictedPackagesExemptClasses, runtimeServices.getConfiguration().getBoolean("introspector.validate.exemptions.disable", false), runtimeServices.getConfiguration().getStringArray("introspector.allow.packages"), runtimeServices.getConfiguration().getBoolean("introspector.proper.allowlist.enable", false), runtimeServices.getConfiguration().getBoolean("introspector.proper.allowlist.debug.enable", false), runtimeServices.getConfiguration().getStringArray("introspector.proper.allowlist.methods"), runtimeServices.getConfiguration().getStringArray("introspector.proper.allowlist.classes"), runtimeServices.getConfiguration().getStringArray("introspector.proper.allowlist.packages"), parameterFilteringExemptMethodNames, runtimeServices.getConfiguration().getString("introspector.method.translator", MethodTranslatorImpl.class.getName()), log, runtimeServices);
    }

    @Deprecated
    public SecureIntrospectorImpl(String[] restrictedClasses, String[] restrictedPackages, String[] restrictedPackagesExemptClasses, Log log, RuntimeServices runtimeServices) {
        this(restrictedClasses, restrictedPackages, restrictedPackagesExemptClasses, runtimeServices.getConfiguration().getStringArray("introspector.allowlist.methods"), log, runtimeServices);
    }

    protected boolean isIntrospectorEnabled() {
        return true;
    }

    protected boolean isAllowlistEnabled() {
        return this.isAllowlistEnabled;
    }

    protected boolean isAllowlistDebugMode() {
        return this.isAllowlistDebugMode;
    }

    public static Set<String> toParsedSet(String[] array) {
        return Collections.unmodifiableSet(Arrays.stream(array).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()));
    }

    @Override
    public Method getMethod(Class clazz, String methodName, Object[] params) throws IllegalArgumentException {
        return this.getMethod(null, clazz, methodName, params);
    }

    @Override
    public Method getMethod(Object target, Class clazz, String methodName, Object[] params) throws IllegalArgumentException {
        Method method = super.getMethod(clazz, methodName, params);
        if (method == null) {
            return null;
        }
        if (this.isExecutionRestricted(target, method, params)) {
            return null;
        }
        return method;
    }

    public boolean isExecutionRestricted(Object target, Method method, Object[] params) {
        if (this.isParametersRestricted(method, params)) {
            return true;
        }
        return !this.checkObjectExecutePermission(target, method);
    }

    protected boolean isParametersRestricted(Method method, Object[] params) {
        if (this.parameterFilteringExemptMethodNames.contains(method.getName())) {
            return false;
        }
        if (this.isParamsContainPathTraversal(params)) {
            this.log.warn(SecureIntrospectorImpl.toPathTraversalWarning(method.getName(), method.getDeclaringClass(), params));
            return true;
        }
        return false;
    }

    protected boolean isParamsContainPathTraversal(Object[] params) {
        return Arrays.stream(params).anyMatch(param -> param instanceof String && FilesystemUtils.containsPathTraversal((String)param));
    }

    private static String toPathTraversalWarning(String methodName, Class clazz, Object[] params) {
        return String.format("Found a potential path traversal attempt in the parameters: %s of method: %s from object of class: %s, rejecting due to security restrictions.", Arrays.toString(params), methodName, clazz.getName());
    }

    @Override
    public boolean checkObjectExecutePermission(Class clazz, String methodName) {
        if (!this.isIntrospectorEnabled()) {
            return true;
        }
        Boolean topLevelCheck = this.topLevelChecks(clazz, methodName);
        if (topLevelCheck != null) {
            return topLevelCheck;
        }
        Class<?> checkClass = this.resolveArrayClass(clazz);
        if (this.isRestrictedClass(checkClass)) {
            return false;
        }
        return this.isAllowlistedClass(checkClass);
    }

    protected Boolean topLevelChecks(Class<?> clazz, String methodName) {
        if ("wait".equals(methodName) || "notify".equals(methodName)) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Class.class.isAssignableFrom(clazz) && "getName".equals(methodName)) {
            return true;
        }
        return null;
    }

    @Override
    public boolean checkObjectExecutePermission(Object target, Method method) {
        if (!this.isIntrospectorEnabled()) {
            return true;
        }
        if (method == null) {
            throw new IllegalArgumentException();
        }
        Class<?> checkClass = target != null ? target.getClass() : method.getDeclaringClass();
        Boolean topLevelCheck = this.topLevelChecks(checkClass, method.getName());
        if (topLevelCheck != null) {
            return topLevelCheck;
        }
        Method checkMethod = method;
        if (target != null && (checkMethod = this.methodTranslator.getTranslatedMethod(target, method)) != method) {
            checkClass = checkMethod.getDeclaringClass();
        }
        if (this.isRestrictedClass(checkClass = this.resolveArrayClass(checkClass))) {
            return false;
        }
        return this.isAllowlisted(checkMethod);
    }

    protected boolean isAllowlisted(Method method) {
        if (!this.isAllowlistEnabled()) {
            return true;
        }
        boolean result = this.isAllowlistedInternal(method);
        if (!result) {
            String msg = this.isAllowlistDebugMode() ? "DEBUG MODE: Method needs allowlisting: " : "Invocation blocked as method is not allowlisted: ";
            this.log.warn(msg + method.getDeclaringClass().getName() + "#" + SecureIntrospectorImpl.toMethodStr(method) + this.appendedToClassRelatedLogging(method.getDeclaringClass()));
        }
        return result || this.isAllowlistDebugMode();
    }

    protected boolean isAllowlistedInternal(Method method) {
        return this.isAllowlistedClassPackageCached(method.getDeclaringClass()) || this.isAllowlistedMethodCached(method);
    }

    protected boolean isAllowlistedClass(Class<?> clazz) {
        if (!this.isAllowlistEnabled()) {
            return true;
        }
        boolean result = this.isAllowlistedClassPackageCached(clazz);
        if (!result) {
            String msg = this.isAllowlistDebugMode() ? "DEBUG MODE: Class needs allowlisting: " : "Invocation blocked as class is not allowlisted: ";
            this.log.warn(msg + clazz.getName() + this.appendedToClassRelatedLogging(clazz));
        }
        return result || this.isAllowlistDebugMode();
    }

    protected Class<?> resolveArrayClass(Class<?> clazz) {
        return clazz.isArray() ? clazz.getComponentType() : clazz;
    }

    protected boolean isRestrictedClass(Class<?> clazz) {
        boolean result = this.isRestrictedClassPackageCached(clazz);
        if (result) {
            this.log.warn("Invocation blocked as class is restricted: " + clazz.getName() + this.appendedToClassRelatedLogging(clazz));
        }
        return result;
    }

    protected String appendedToClassRelatedLogging(Class<?> clazz) {
        return "";
    }

    protected boolean isRestrictedClassPackageCached(Class<?> clazz) {
        return this.restrictedClassCache.computeIfAbsent(clazz, this::isRestrictedClassPackageInternal);
    }

    protected boolean isRestrictedClassPackageInternal(Class<?> clazz) {
        Set<Class<?>> allCheckClasses = this.getAllInterfacesAndSuperclasses(clazz);
        return allCheckClasses.stream().anyMatch(this::isClassRestricted) || allCheckClasses.stream().anyMatch(this::isClassPackageRestricted);
    }

    protected boolean isAllowlistedClassPackageCached(Class<?> clazz) {
        return this.allowlistedClassCache.computeIfAbsent(clazz, this::isAllowlistedClassPackageInternal);
    }

    protected boolean isAllowlistedClassPackageInternal(Class<?> clazz) {
        return clazz.isPrimitive() || this.allowlistedClassesRef.get().contains(clazz) || SecureIntrospectorImpl.isPackageMatches(clazz.getPackage(), this.allowlistedPackages);
    }

    protected boolean isAllowlistedMethodCached(Method method) {
        return this.allowlistedMethodCache.computeIfAbsent(method, this::isAllowlistedMethodInternal);
    }

    protected boolean isAllowlistedMethodInternal(Method method) {
        Set<String> methodAllowlist = this.allowlistedMethodsRef.get().get(method.getDeclaringClass());
        return methodAllowlist != null && methodAllowlist.contains(SecureIntrospectorImpl.toMethodStr(method));
    }

    public static String toMethodStr(Method method) {
        return method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(" ")) + ")";
    }

    protected Set<String> toValidatedClassSet(String[] classNames) {
        return Collections.unmodifiableSet(this.toClassSet(classNames).stream().map(Class::getName).collect(Collectors.toSet()));
    }

    protected Set<Class<?>> toClassSet(String[] classNames) {
        HashSet classSet = new HashSet();
        for (String className : SecureIntrospectorImpl.toParsedSet(classNames)) {
            try {
                classSet.add(this.loadClassAndLog(className));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return Collections.unmodifiableSet(classSet);
    }

    protected Map<Class<?>, Set<String>> toMethodSet(String[] methodList) {
        Map<String, Set<String>> parsedMethods = this.toParsedMethodMap(Arrays.asList(methodList));
        HashMap loadedMethods = new HashMap();
        for (Map.Entry<String, Set<String>> entry : parsedMethods.entrySet()) {
            Class<?> clazz;
            String clazzName = entry.getKey();
            Set<String> methodNames = entry.getValue();
            try {
                clazz = this.loadClassAndLog(clazzName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            Set<String> invalidMethods = SecureIntrospectorImpl.findUndeclaredMethods(clazz, methodNames);
            if (!invalidMethods.isEmpty()) {
                this.logValidationError(String.format("Cannot locate method(s) %s for class %s for security introspection in Velocity", String.join((CharSequence)", ", invalidMethods), clazz.getName()));
                methodNames.removeAll(invalidMethods);
            }
            loadedMethods.put(clazz, methodNames);
        }
        return Collections.unmodifiableMap(loadedMethods);
    }

    private Map<String, Set<String>> toParsedMethodMap(Collection<String> methodList) {
        HashMap methods = new HashMap();
        for (String methodStr : methodList) {
            String[] parts = methodStr.trim().split("#");
            if (parts.length != 2) {
                this.logValidationError("Invalid method format, should be \"package.Class#method(qualified.paramType1 qualified.paramType2)\", provided method was: " + methodStr);
            }
            String className = parts[0];
            String methodName = parts[1];
            methods.putIfAbsent(className, new HashSet());
            ((Set)methods.get(className)).add(methodName);
        }
        return Collections.unmodifiableMap(methods);
    }

    private static Set<String> findUndeclaredMethods(Class<?> clazz, Set<String> methods) {
        Set declaredMethods = Arrays.stream(clazz.getDeclaredMethods()).map(SecureIntrospectorImpl::toMethodStr).collect(Collectors.toSet());
        return methods.stream().filter(method -> !declaredMethods.contains(method)).collect(Collectors.toSet());
    }

    protected Class<?> loadClassAndLog(String name) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            this.logValidationError("Cannot load class for security introspection in Velocity: " + name);
            throw e;
        }
        this.log.debug("Loaded class for security introspection in Velocity: " + name + this.appendedToClassRelatedLogging(clazz));
        return clazz;
    }

    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        return ClassUtils.getClass(name);
    }

    protected boolean isClassRestricted(Class<?> clazz) {
        return this.restrictedClassesRef.get().contains(clazz.getName());
    }

    protected boolean isClassPackageRestricted(Class<?> clazz) {
        return !this.restrictedPackagesExemptClassesRef.get().contains(clazz) && !this.restrictedPackagesExemptClasses.contains(clazz.getName()) && !this.restrictedPackagesExemptPackages.contains(SecureIntrospectorImpl.toPackageName(clazz.getPackage())) && SecureIntrospectorImpl.isPackageMatches(clazz.getPackage(), this.restrictedPackages);
    }

    public static String toPackageName(Package packag) {
        return packag != null ? packag.getName() : "";
    }

    public static boolean isPackageMatches(Package packag, Set<String> matchingPackages) {
        List<String> packageParts = Arrays.asList(SecureIntrospectorImpl.toPackageName(packag).split("\\."));
        return IntStream.range(0, packageParts.size()).mapToObj(i -> String.join((CharSequence)".", packageParts.subList(0, i + 1))).anyMatch(matchingPackages::contains);
    }

    private Set<Class<?>> getAllInterfacesAndSuperclasses(Class<?> clazz) {
        HashSet allInterfacesAndClass = new HashSet();
        allInterfacesAndClass.add(clazz);
        allInterfacesAndClass.addAll(org.apache.commons.lang3.ClassUtils.getAllInterfaces(clazz));
        allInterfacesAndClass.addAll(org.apache.commons.lang3.ClassUtils.getAllSuperclasses(clazz));
        return allInterfacesAndClass;
    }

    private void logValidationError(String message) {
        if (!this.isSilentValidation) {
            this.log.warn(message);
        } else {
            this.log.debug(message);
        }
    }
}

