/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.monitor.scheduler;

import com.atlassian.diagnostics.internal.platform.monitor.scheduler.RunningJobDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.scheduler.ScheduledJobDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.scheduler.SchedulerDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.scheduler.SchedulerDiagnosticProvider;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.caesium.impl.CaesiumSchedulerService;
import com.atlassian.scheduler.caesium.spi.CaesiumSchedulerConfiguration;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.core.RunningJob;
import com.atlassian.scheduler.core.SchedulerServiceController;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultSchedulerDiagnosticProvider
implements SchedulerDiagnosticProvider {
    private final CaesiumSchedulerConfiguration caesiumSchedulerConfiguration;
    private final SchedulerHistoryService schedulerHistoryService;
    private final SchedulerServiceController schedulerServiceController;
    private final SchedulerService schedulerService;
    private Optional<CaesiumSchedulerService> caesiumSchedulerService = Optional.empty();

    public DefaultSchedulerDiagnosticProvider(CaesiumSchedulerConfiguration caesiumSchedulerConfiguration, SchedulerHistoryService schedulerHistoryService, SchedulerServiceController schedulerServiceController, SchedulerService schedulerService) {
        this.caesiumSchedulerConfiguration = caesiumSchedulerConfiguration;
        this.schedulerHistoryService = schedulerHistoryService;
        this.schedulerServiceController = schedulerServiceController;
        this.schedulerService = schedulerService;
        if (schedulerService instanceof CaesiumSchedulerService) {
            this.caesiumSchedulerService = Optional.of((CaesiumSchedulerService)schedulerService);
        } else if (schedulerServiceController instanceof CaesiumSchedulerService) {
            this.caesiumSchedulerService = Optional.of((CaesiumSchedulerService)schedulerServiceController);
        }
    }

    @Override
    public SchedulerDiagnostic getDiagnostic() {
        int workerThreadCount = this.caesiumSchedulerConfiguration.workerThreadCount();
        return new SchedulerDiagnostic(workerThreadCount, this.getRunningJobs(), this.getScheduledJobs());
    }

    private List<RunningJobDiagnostic> getRunningJobs() {
        return this.schedulerServiceController.getLocallyRunningJobs().stream().map(runningJob -> {
            Optional<JobRunner> jobRunner = this.getJobRunner(runningJob.getJobConfig().getJobRunnerKey());
            return new RunningJobDiagnostic((RunningJob)runningJob, jobRunner);
        }).collect(Collectors.toList());
    }

    private List<ScheduledJobDiagnostic> getScheduledJobs() {
        List allScheduledJobsJobDetails = this.schedulerService.getJobsByJobRunnerKeys(new ArrayList(this.schedulerService.getJobRunnerKeysForAllScheduledJobs()));
        Map runDetailsByJobId = this.schedulerHistoryService.getLastRunForJobs(allScheduledJobsJobDetails.stream().map(JobDetails::getJobId).collect(Collectors.toList()));
        return allScheduledJobsJobDetails.stream().map(jobDetails -> new ScheduledJobDiagnostic((JobDetails)jobDetails, this.getRunDetails((JobDetails)jobDetails, runDetailsByJobId), this.getJobRunner(jobDetails.getJobRunnerKey()))).collect(Collectors.toList());
    }

    private Optional<RunDetails> getRunDetails(JobDetails jobDetails, Map<JobId, RunDetails> jobDetailsRunDetailsMap) {
        return Optional.ofNullable(jobDetailsRunDetailsMap.get(jobDetails.getJobId()));
    }

    private Optional<JobRunner> getJobRunner(JobRunnerKey jobRunnerKey) {
        return this.caesiumSchedulerService.map(service -> service.getJobRunner(jobRunnerKey));
    }
}

