/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.collaborative.content.feedback.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.collaborative.content.feedback.rest.Utils;
import com.atlassian.confluence.plugins.collaborative.content.feedback.rest.model.CollectMetadata;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.AuditingService;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.DataExportService;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.FileNameUtils;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.PermissionService;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Path(value="/")
@Produces(value={"application/json"})
public class CollaborativeFeedbackResource {
    private static final String COLLECTED_DATA_ACTION_KEY = "audit.logging.collaborative.feedback.data.collected";
    private static final String DOWNLOADED_DATA_ACTION_KEY = "audit.logging.collaborative.feedback.data.downloaded";
    private static final String DELETED_DATA_ACTION_KEY = "audit.logging.collaborative.feedback.data.deleted";
    private final DataExportService dataExportService;
    private final PermissionService permissionService;
    private final SettingsManager settingsManager;
    private final AuditingService auditingService;

    @Inject
    public CollaborativeFeedbackResource(DataExportService dataExportService, PermissionService permissionService, SettingsManager settingsManager, AuditingService auditingService) {
        this.dataExportService = dataExportService;
        this.permissionService = permissionService;
        this.settingsManager = settingsManager;
        this.auditingService = auditingService;
    }

    @PUT
    @Path(value="collect/{contentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response collectData(@PathParam(value="contentId") long contentId, CollectMetadata meta) {
        return Utils.executeAndRespond(() -> {
            this.auditingService.audit(contentId, COLLECTED_DATA_ACTION_KEY);
            return Collections.singletonMap("result-file", this.dataExportService.exportDataFor(contentId, meta));
        });
    }

    @GET
    @Path(value="file/list")
    @ScopesAllowed(requiredScope={"READ"})
    public Response listFiles() {
        return Utils.executeAndRespond(() -> {
            this.permissionService.enforceSysAdmin(AuthenticatedUserThreadLocal.get());
            return Arrays.stream(Objects.requireNonNull(this.settingsManager.getDestinationFolder().listFiles())).map(File::getName).filter(FileNameUtils::isValidFileName).collect(Collectors.toList());
        });
    }

    @GET
    @Path(value="file")
    @Produces(value={"application/octet-stream"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response downloadFile(@QueryParam(value="fileName") String fileName) {
        return Utils.executeAndWrapExceptions(() -> this.invalidContext(fileName).orElseGet(() -> {
            this.auditingService.audit(FileNameUtils.getContentId(fileName), DOWNLOADED_DATA_ACTION_KEY);
            File fileToDownload = new File(this.settingsManager.getDestinationFolder(), Objects.requireNonNull(fileName));
            if (!fileToDownload.exists()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)fileToDownload).header("content-disposition", (Object)("attachment; filename = " + fileName)).build();
        }));
    }

    @DELETE
    @Path(value="file")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteFile(@QueryParam(value="fileName") String fileName) {
        return Utils.executeAndWrapExceptions(() -> this.invalidContext(fileName).orElseGet(() -> {
            this.auditingService.audit(FileNameUtils.getContentId(fileName), DELETED_DATA_ACTION_KEY);
            File fileToDelete = new File(this.settingsManager.getDestinationFolder(), Objects.requireNonNull(fileName));
            if (!fileToDelete.exists()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity((Object)("{\"success\": " + fileToDelete.delete() + "}")).build();
        }));
    }

    private Optional<Response> invalidContext(String fileName) {
        if (!this.permissionService.isSysAdmin(AuthenticatedUserThreadLocal.get())) {
            return Optional.of(Response.status((int)403).build());
        }
        if (!FileNameUtils.isValidFileName(fileName)) {
            return Optional.of(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        return Optional.empty();
    }
}

