/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.collaborative.content.feedback.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.collaborative.content.feedback.rest.Utils;
import com.atlassian.confluence.plugins.collaborative.content.feedback.rest.model.Settings;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.AuditingService;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.PermissionService;
import com.atlassian.confluence.plugins.collaborative.content.feedback.service.SettingsManager;
import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;

@Path(value="/settings")
@Produces(value={"application/json"})
public class SettingsResource {
    private static final String UPDATE_SETTINGS_ACTION_KEY = "audit.logging.collaborative.feedback.settings.updated";
    private final PermissionService permissionService;
    private final SettingsManager settingsManager;
    private final AuditingService auditingService;
    private final SynchronyConfigurationManager configManager;

    @Inject
    public SettingsResource(PermissionService permissionService, SettingsManager settingsManager, AuditingService auditingService, @ComponentImport SynchronyConfigurationManager configManager) {
        this.permissionService = permissionService;
        this.settingsManager = settingsManager;
        this.auditingService = auditingService;
        this.configManager = configManager;
    }

    @GET
    @Path(value="/collab")
    @ScopesAllowed(requiredScope={"READ"})
    public Response collaborativeEditingStatus() {
        return Utils.executeAndRespond(() -> {
            this.permissionService.enforceSysAdmin(AuthenticatedUserThreadLocal.get());
            return Collections.singletonMap("sharedDraftsEnabled", this.configManager.isSharedDraftsEnabled());
        });
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response settings() {
        return Utils.executeAndRespond(() -> {
            this.permissionService.enforceSysAdmin(AuthenticatedUserThreadLocal.get());
            return this.buildSettings();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateSettings(Settings settings) {
        return Utils.executeAndRespond(() -> {
            this.permissionService.enforceSysAdmin(AuthenticatedUserThreadLocal.get());
            this.auditingService.audit(this.buildSettings(), settings, UPDATE_SETTINGS_ACTION_KEY);
            this.settingsManager.setEditorReportsEnabled(settings.isEditorReportsEnabled());
            return this.buildSettings();
        });
    }

    private Settings buildSettings() {
        return new Settings(this.settingsManager.getDestinationFolder().getAbsolutePath(), this.settingsManager.getMaxFiles(), this.settingsManager.getMaxConcurrentRequests(), this.settingsManager.getOperationTimeout(), this.settingsManager.isEditorReportsEnabled(), this.settingsManager.dataRetention());
    }
}

