/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.collaborative.content.feedback.service;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.permission.AuthorisationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionService {
    private final PermissionManager permissionManager;
    private final PageManager pageManager;

    @Autowired
    public PermissionService(@ComponentImport PermissionManager permissionManager, @ComponentImport PageManager pageManager) {
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
    }

    public boolean isSysAdmin(ConfluenceUser user) {
        return user != null && (this.permissionManager.isSystemAdministrator(user) || this.permissionManager.isConfluenceAdministrator(user));
    }

    public void enforceSysAdmin(ConfluenceUser user) {
        if (!this.isSysAdmin(user)) {
            throw new AuthorisationException();
        }
    }

    public boolean canEdit(@Nullable ConfluenceUser user, long contentId) {
        return user != null && this.permissionManager.hasPermission(user, Permission.EDIT, (Object)this.pageManager.getAbstractPage(contentId));
    }
}

