/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.jirareports;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json"})
@AnonymousSiteAccess
public class JiraReportsResource {
    private static final String PROJECT_REST_URI = "/rest/api/2/project";
    private static final Logger LOG = LoggerFactory.getLogger(JiraReportsResource.class);
    private final ApplicationLinkService appLinkService;

    @Inject
    public JiraReportsResource(ApplicationLinkService appLinkService) {
        this.appLinkService = appLinkService;
    }

    @GET
    @Path(value="appLink/{appLinkId}/projects")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getProjectsByAppLinkId(@PathParam(value="appLinkId") String appLinkId) {
        ApplicationLink appLink = null;
        String url = null;
        try {
            appLink = this.appLinkService.getApplicationLink(new ApplicationId(appLinkId));
            url = String.valueOf(appLink.getRpcUrl()) + PROJECT_REST_URI;
            String projects = this.requestJiraByAuthenticatedUser((ReadOnlyApplicationLink)appLink, url);
            return Response.ok((Object)projects).build();
        }
        catch (CredentialsRequiredException e) {
            String projects = this.requestJiraByAnonymousUser((ReadOnlyApplicationLink)appLink, url);
            return this.buildUnAuthenticatedResponse(projects, e.getAuthorisationURI().toString());
        }
        catch (Exception e) {
            LOG.error("Can not retrieve projects", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    @GET
    @Path(value="appLink/{appLinkId}/project/{projectKey}/versions")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getVersionsByKeyProject(@PathParam(value="appLinkId") String appLinkId, @PathParam(value="projectKey") String projectKey) {
        ApplicationLink appLink = null;
        String url = null;
        try {
            appLink = this.appLinkService.getApplicationLink(new ApplicationId(appLinkId));
            url = String.valueOf(appLink.getRpcUrl()) + "/rest/api/2/project/" + projectKey + "/versions";
            String versions = this.requestJiraByAuthenticatedUser((ReadOnlyApplicationLink)appLink, url);
            return Response.ok((Object)versions).build();
        }
        catch (CredentialsRequiredException e) {
            String versions = this.requestJiraByAnonymousUser((ReadOnlyApplicationLink)appLink, url);
            return this.buildUnAuthenticatedResponse(versions, e.getAuthorisationURI().toString());
        }
        catch (Exception e) {
            LOG.error("Can not retrieve versions", (Throwable)e);
            return Response.status((int)400).build();
        }
    }

    private Response buildUnAuthenticatedResponse(String responseData, String authorisationURI) {
        Response.ResponseBuilder response = Response.status((int)401).header("WWW-Authenticate", (Object)("OAuth realm=\"" + authorisationURI + "\""));
        if (responseData != null) {
            response.entity((Object)responseData);
        }
        return response.build();
    }

    private String requestJiraByAnonymousUser(ReadOnlyApplicationLink appLink, String url) {
        try {
            ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory(Anonymous.class);
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, url);
            return request.execute();
        }
        catch (Exception e) {
            LOG.error("Can not retrieve data from jira server by anonymous user", (Throwable)e);
            return null;
        }
    }

    private String requestJiraByAuthenticatedUser(ReadOnlyApplicationLink appLink, String url) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, url);
        return request.execute();
    }
}

