/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rest.plugins;

import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.rest.plugins.ClientsideExtensionsAssetsDto;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@Path(value="client-plugins")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ClientsideExtensionsResource {
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final DynamicWebInterfaceManager manager;

    @Inject
    public ClientsideExtensionsResource(ApplicationProperties applicationProperties, DynamicWebInterfaceManager manager) {
        this.applicationProperties = applicationProperties;
        this.manager = manager;
    }

    @GET
    @Path(value="/items")
    public Response getWebItems(@QueryParam(value="location") String location, @Nonnull @QueryParam(value="key") List<String> keys) {
        String contextPath = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        List<WebItem> webItemsBySection = StreamSupport.stream(ClientsideExtensionsResource.getWebItemsBySection(this.manager, location).spliterator(), false).collect(Collectors.toList());
        if (keys.isEmpty()) {
            return ClientsideExtensionsResource.toResponse(webItemsBySection, contextPath);
        }
        return ClientsideExtensionsResource.toResponse(ClientsideExtensionsResource.getWebItemsByKey(webItemsBySection, keys), contextPath);
    }

    private static Map<String, Object> getContext() {
        return new HashMap<String, Object>();
    }

    private static List<WebItem> getWebItemsByKey(List<WebItem> items, List<String> keys) {
        return items.stream().filter(webItem -> {
            String webItemKey = webItem.getCompleteKey();
            return keys.stream().anyMatch(key -> key.equals(webItemKey));
        }).collect(Collectors.toList());
    }

    private static Iterable<WebItem> getWebItemsBySection(DynamicWebInterfaceManager manager, String section) {
        return (Iterable)SafePluginPointAccess.call(() -> manager.getDisplayableWebItems(section, ClientsideExtensionsResource.getContext())).getOrElse(Collections.emptyList());
    }

    private static Response toResponse(List<WebItem> items, @Nonnull String contextPath) {
        return Response.ok((Object)new ClientsideExtensionsAssetsDto(items, contextPath)).build();
    }
}

