/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.BinaryTSFactory;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.sym.BinaryNameMatcher;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.Named;
import tools.jackson.dataformat.cbor.CBORFactoryBuilder;
import tools.jackson.dataformat.cbor.CBORGenerator;
import tools.jackson.dataformat.cbor.CBORParser;
import tools.jackson.dataformat.cbor.CBORParserBootstrapper;
import tools.jackson.dataformat.cbor.CBORReadFeature;
import tools.jackson.dataformat.cbor.CBORWriteFeature;
import tools.jackson.dataformat.cbor.PackageVersion;

public class CBORFactory
extends BinaryTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME = "CBOR";
    static final int DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS = CBORWriteFeature.collectDefaults();
    static final int DEFAULT_CBOR_PARSER_FEATURE_FLAGS = CBORReadFeature.collectDefaults();
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();

    public CBORFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), DEFAULT_CBOR_PARSER_FEATURE_FLAGS, DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS);
    }

    public CBORFactory(CBORFactory src) {
        super((BinaryTSFactory)src);
    }

    protected CBORFactory(CBORFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
    }

    public CBORFactoryBuilder rebuild() {
        return new CBORFactoryBuilder(this);
    }

    public static CBORFactoryBuilder builder() {
        return new CBORFactoryBuilder();
    }

    public CBORFactory copy() {
        return new CBORFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new CBORFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canParseAsync() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Class<CBORReadFeature> getFormatReadFeatureType() {
        return CBORReadFeature.class;
    }

    public Class<CBORWriteFeature> getFormatWriteFeatureType() {
        return CBORWriteFeature.class;
    }

    public boolean isEnabled(CBORReadFeature f) {
        return f.enabledIn(this._formatReadFeatures);
    }

    public boolean isEnabled(CBORWriteFeature f) {
        return f.enabledIn(this._formatWriteFeatures);
    }

    protected IOContext _createContext(ContentReference contentRef, boolean resourceManaged) {
        return super._createContext(contentRef, resourceManaged);
    }

    protected CBORParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        return new CBORParserBootstrapper(ioCtxt, in).constructParser(readCtxt, this._factoryFeatures, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._byteSymbolCanonicalizer);
    }

    protected CBORParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        return new CBORParserBootstrapper(ioCtxt, data, offset, len).constructParser(readCtxt, this._factoryFeatures, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._byteSymbolCanonicalizer);
    }

    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ctxt, DataInput input) {
        return (JsonParser)this._unsupported();
    }

    protected JsonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) {
        CBORGenerator gen = new CBORGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), out);
        if (CBORWriteFeature.WRITE_TYPE_HEADER.enabledIn(this._formatWriteFeatures)) {
            gen.writeTag(55799);
        }
        if (CBORWriteFeature.STRINGREF.enabledIn(this._formatWriteFeatures)) {
            gen.writeTag(256);
        }
        return gen;
    }

    public PropertyNameMatcher constructNameMatcher(List<Named> matches, boolean alreadyInterned) {
        return BinaryNameMatcher.constructFrom(matches, (boolean)alreadyInterned);
    }

    public PropertyNameMatcher constructCINameMatcher(List<Named> matches, boolean alreadyInterned, Locale locale) {
        return BinaryNameMatcher.constructCaseInsensitive((Locale)locale, matches, (boolean)alreadyInterned);
    }
}

