/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.dataformat.cbor.CBORFactory;
import tools.jackson.dataformat.cbor.CBORReadFeature;
import tools.jackson.dataformat.cbor.CBORWriteFeature;

public class CBORFactoryBuilder
extends DecorableTSFactory.DecorableTSFBuilder<CBORFactory, CBORFactoryBuilder> {
    protected CBORFactoryBuilder() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), CBORFactory.DEFAULT_CBOR_PARSER_FEATURE_FLAGS, CBORFactory.DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS);
    }

    public CBORFactoryBuilder(CBORFactory base) {
        super((DecorableTSFactory)base);
    }

    public CBORFactoryBuilder enable(CBORWriteFeature f) {
        this._formatWriteFeatures |= f.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder enable(CBORWriteFeature first, CBORWriteFeature ... other) {
        this._formatWriteFeatures |= first.getMask();
        for (CBORWriteFeature f : other) {
            this._formatWriteFeatures |= f.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORWriteFeature f) {
        this._formatWriteFeatures &= ~f.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORWriteFeature first, CBORWriteFeature ... other) {
        this._formatWriteFeatures &= ~first.getMask();
        for (CBORWriteFeature f : other) {
            this._formatWriteFeatures &= ~f.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder configure(CBORWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CBORFactoryBuilder enable(CBORReadFeature f) {
        this._formatReadFeatures |= f.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder enable(CBORReadFeature first, CBORReadFeature ... other) {
        this._formatReadFeatures |= first.getMask();
        for (CBORReadFeature f : other) {
            this._formatReadFeatures |= f.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORReadFeature f) {
        this._formatReadFeatures &= ~f.getMask();
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder disable(CBORReadFeature first, CBORReadFeature ... other) {
        this._formatReadFeatures &= ~first.getMask();
        for (CBORReadFeature f : other) {
            this._formatReadFeatures &= ~f.getMask();
        }
        return (CBORFactoryBuilder)this._this();
    }

    public CBORFactoryBuilder configure(CBORReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CBORFactory build() {
        return new CBORFactory(this);
    }
}

