/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import java.io.Serializable;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.dataformat.cbor.CBORFactory;
import tools.jackson.dataformat.cbor.CBORReadFeature;
import tools.jackson.dataformat.cbor.CBORWriteFeature;
import tools.jackson.dataformat.cbor.PackageVersion;

public class CBORMapper
extends ObjectMapper {
    private static final long serialVersionUID = 3L;

    public CBORMapper() {
        this(new CBORFactory());
    }

    public CBORMapper(CBORFactory f) {
        this(new Builder(f));
    }

    public CBORMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new CBORFactory());
    }

    public static Builder builder(CBORFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static CBORMapper shared() {
        return SharedWrapper.wrapped();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public CBORFactory tokenStreamFactory() {
        return (CBORFactory)this._streamFactory;
    }

    public static class Builder
    extends MapperBuilder<CBORMapper, Builder> {
        public Builder(CBORFactory f) {
            super((TokenStreamFactory)f);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public CBORMapper build() {
            return new CBORMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(CBORReadFeature ... features) {
            for (CBORReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(CBORReadFeature ... features) {
            for (CBORReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(CBORReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(CBORWriteFeature ... features) {
            for (CBORWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(CBORWriteFeature ... features) {
            for (CBORWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(CBORWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final CBORMapper MAPPER = CBORMapper.builder().build();

        private SharedWrapper() {
        }

        public static CBORMapper wrapped() {
            return MAPPER;
        }
    }
}

