/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import java.io.IOException;
import java.io.InputStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.dataformat.cbor.CBORParser;

public class CBORParserBootstrapper {
    protected final IOContext _ioContext;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public CBORParserBootstrapper(IOContext ioCtxt, InputStream in) {
        this._ioContext = ioCtxt;
        this._in = in;
        this._inputBuffer = ioCtxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public CBORParserBootstrapper(IOContext ioCtxt, byte[] inputBuffer, int inputStart, int inputLen) {
        this._ioContext = ioCtxt;
        this._in = null;
        this._inputBuffer = inputBuffer;
        this._inputPtr = inputStart;
        this._inputEnd = inputStart + inputLen;
        this._inputProcessed = -inputStart;
        this._bufferRecyclable = false;
    }

    public CBORParser constructParser(ObjectReadContext readCtxt, int factoryFeatures, int generalParserFeatures, int formatFeatures, ByteQuadsCanonicalizer rootByteSymbols) throws JacksonException {
        ByteQuadsCanonicalizer can = rootByteSymbols.makeChildOrPlaceholder(factoryFeatures);
        this.ensureLoaded(1);
        CBORParser p = new CBORParser(readCtxt, this._ioContext, generalParserFeatures, formatFeatures, can, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        if (this._inputPtr < this._inputEnd) {
            // empty if block
        }
        return p;
    }

    protected boolean ensureLoaded(int minimum) throws JacksonException {
        int count;
        if (this._in == null) {
            return false;
        }
        for (int gotten = this._inputEnd - this._inputPtr; gotten < minimum; gotten += count) {
            try {
                count = this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            }
            catch (IOException e) {
                throw JacksonIOException.construct((IOException)e);
            }
            if (count < 1) {
                return false;
            }
            this._inputEnd += count;
        }
        return true;
    }
}

