/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.CharTypes;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.json.DupDetector;

public final class CBORReadContext
extends TokenStreamContext {
    protected final CBORReadContext _parent;
    protected final DupDetector _dups;
    protected int _expEntryCount;
    protected String _currentName;
    protected Object _currentValue;
    protected CBORReadContext _child = null;

    public CBORReadContext(CBORReadContext parent, DupDetector dups, int type, int expEntryCount) {
        this._parent = parent;
        this._dups = dups;
        this._type = type;
        this._expEntryCount = expEntryCount;
        this._index = -1;
        this._nestingDepth = parent == null ? 0 : parent._nestingDepth + 1;
    }

    protected void reset(int type, int expEntryCount) {
        this._type = type;
        this._expEntryCount = expEntryCount;
        this._index = -1;
        this._currentName = null;
        this._currentValue = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static CBORReadContext createRootContext(DupDetector dups) {
        return new CBORReadContext(null, dups, 0, -1);
    }

    public CBORReadContext createChildArrayContext(int expEntryCount) {
        CBORReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new CBORReadContext(this, this._dups == null ? null : this._dups.child(), 1, expEntryCount);
        } else {
            ctxt.reset(1, expEntryCount);
        }
        return ctxt;
    }

    public CBORReadContext createChildObjectContext(int expEntryCount) {
        CBORReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new CBORReadContext(this, this._dups == null ? null : this._dups.child(), 2, expEntryCount);
            return ctxt;
        }
        ctxt.reset(2, expEntryCount);
        return ctxt;
    }

    public String currentName() {
        return this._currentName;
    }

    public CBORReadContext getParent() {
        return this._parent;
    }

    public boolean hasExpectedLength() {
        return this._expEntryCount >= 0;
    }

    public int getExpectedLength() {
        return this._expEntryCount;
    }

    public int getRemainingExpectedLength() {
        int diff = this._expEntryCount - this._index;
        return Math.max(0, diff);
    }

    public boolean acceptsBreakMarker() {
        return this._expEntryCount < 0 && this._type != 0;
    }

    public boolean expectMoreValues() {
        return ++this._index != this._expEntryCount;
    }

    public TokenStreamLocation startLocation(ContentReference srcRef) {
        return new TokenStreamLocation(srcRef, 1L, -1, -1);
    }

    public void setCurrentName(String name) throws StreamReadException {
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
    }

    private void _checkDup(DupDetector dd, String name) throws StreamReadException {
        if (dd.isDup(name)) {
            Object src = dd.getSource();
            throw new StreamReadException(src instanceof JsonParser ? (JsonParser)src : null, "Duplicate Object property \"" + name + "\"");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            case 2: {
                sb.append('{');
                if (this._currentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted((StringBuilder)sb, (String)this._currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append('}');
            }
        }
        return sb.toString();
    }
}

