/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import tools.jackson.core.FormatFeature;

public enum CBORReadFeature implements FormatFeature
{
    DECODE_USING_STANDARD_NEGATIVE_BIGINT_ENCODING(true),
    READ_UNDEFINED_AS_EMBEDDED_OBJECT(true),
    READ_SIMPLE_VALUE_AS_EMBEDDED_OBJECT(true);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (CBORReadFeature f : CBORReadFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private CBORReadFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public boolean enabledIn(int flags) {
        return (flags & this.getMask()) != 0;
    }

    public int getMask() {
        return this._mask;
    }
}

