/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.json.DupDetector;

public final class CBORWriteContext
extends TokenStreamContext {
    protected final CBORWriteContext _parent;
    protected DupDetector _dups;
    protected CBORWriteContext _childToRecycle;
    protected String _currentName;
    protected Object _currentValue;
    protected long _currentPropertyId;
    protected boolean _gotPropertyId;

    protected CBORWriteContext(int type, CBORWriteContext parent, DupDetector dups, Object currentValue) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = parent == null ? 0 : parent._nestingDepth + 1;
        this._dups = dups;
        this._index = -1;
        this._currentValue = currentValue;
    }

    private CBORWriteContext reset(int type, Object currentValue) {
        this._type = type;
        this._index = -1;
        this._gotPropertyId = false;
        this._currentValue = currentValue;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public CBORWriteContext withDupDetector(DupDetector dups) {
        this._dups = dups;
        return this;
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static CBORWriteContext createRootContext(DupDetector dd) {
        return new CBORWriteContext(0, null, dd, null);
    }

    public CBORWriteContext createChildArrayContext(Object currentValue) {
        CBORWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new CBORWriteContext(1, this, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(1, currentValue);
    }

    public CBORWriteContext createChildObjectContext(Object currentValue) {
        CBORWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new CBORWriteContext(2, this, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(2, currentValue);
    }

    public final CBORWriteContext getParent() {
        return this._parent;
    }

    public final String currentName() {
        if (this._gotPropertyId) {
            if (this._currentName != null) {
                return this._currentName;
            }
            return String.valueOf(this._currentPropertyId);
        }
        return null;
    }

    public boolean hasCurrentName() {
        return this._gotPropertyId;
    }

    public CBORWriteContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean writeName(String name) throws StreamWriteException {
        if (this._type != 2 || this._gotPropertyId) {
            return false;
        }
        this._gotPropertyId = true;
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
        return true;
    }

    public boolean writePropertyId(long propertyId) throws StreamWriteException {
        if (this._type != 2 || this._gotPropertyId) {
            return false;
        }
        this._gotPropertyId = true;
        this._currentPropertyId = propertyId;
        return true;
    }

    private final void _checkDup(DupDetector dd, String name) throws StreamWriteException {
        if (dd.isDup(name)) {
            Object src = dd.getSource();
            throw new StreamWriteException(src instanceof JsonGenerator ? (JsonGenerator)src : null, "Duplicate Object property \"" + name + "\"");
        }
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotPropertyId) {
                return false;
            }
            this._gotPropertyId = false;
        }
        ++this._index;
        return true;
    }
}

