/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.cbor;

import tools.jackson.core.FormatFeature;

public enum CBORWriteFeature implements FormatFeature
{
    WRITE_MINIMAL_INTS(true),
    WRITE_TYPE_HEADER(false),
    LENIENT_UTF_ENCODING(false),
    STRINGREF(false),
    WRITE_MINIMAL_DOUBLES(false),
    ENCODE_USING_STANDARD_NEGATIVE_BIGINT_ENCODING(true);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (CBORWriteFeature f : CBORWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private CBORWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public boolean enabledIn(int flags) {
        return (flags & this.getMask()) != 0;
    }

    public int getMask() {
        return this._mask;
    }
}

