/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.spaces;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.core.util.PairType;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
public class SpacesConfigurationAction
extends ConfluenceActionSupport
implements FormAware {
    private static final Logger log = LoggerFactory.getLogger(SpacesConfigurationAction.class);
    private SpaceManager spaceManager;
    private boolean allowThreadedComments;
    private boolean allowRemoteApi;
    private boolean enableQuickNav;
    private boolean enableOpenSearch;
    private int maxSimultaneousQuickNavRequests;
    private int draftSaveIntervalMinutes;
    private int draftSaveIntervalSeconds;
    private static final int DRAFT_SAVE_MIN = 10000;
    private String siteHomePage;
    private boolean editMode = true;

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doView() throws Exception {
        this.editMode = false;
        return this.doDefault();
    }

    public String doDefault() throws Exception {
        Settings globalSettings = this.getGlobalSettings();
        this.allowRemoteApi = globalSettings.isAllowRemoteApi();
        this.allowThreadedComments = globalSettings.isAllowThreadedComments();
        this.enableQuickNav = globalSettings.isEnableQuickNav();
        this.enableOpenSearch = globalSettings.isEnableOpenSearch();
        this.maxSimultaneousQuickNavRequests = globalSettings.getMaxSimultaneousQuickNavRequests();
        this.siteHomePage = globalSettings.getSiteHomePage();
        int draftSaveInterval = globalSettings.getDraftSaveInterval();
        this.draftSaveIntervalMinutes = draftSaveInterval / 1000 / 60;
        this.draftSaveIntervalSeconds = draftSaveInterval / 1000 - this.draftSaveIntervalMinutes * 60;
        return super.doDefault();
    }

    private void validation() {
        if (this.getDraftSaveInterval() < 10000) {
            Object[] args = new String[]{SpacesConfigurationAction.getNiceDuration(0, 10)};
            this.addFieldError("draftSaveIntervalSeconds", "error.minimum.draft.interval", args);
        }
        if (this.isEnableQuickNav() && this.getMaxSimultaneousQuickNavRequests() <= 0) {
            this.addFieldError("maxSimultaneousQuickNavRequests", this.getText("quick.nav.validation.error.max.requests"));
        }
        if (!"dashboard".equals(this.siteHomePage) && !StringUtils.isBlank((CharSequence)this.siteHomePage)) {
            Space siteHomePageParentSpace = this.spaceManager.getSpace(this.siteHomePage);
            if (siteHomePageParentSpace == null) {
                this.addActionError("site.homepage.invalid.space.error", new Object[]{this.siteHomePage});
            } else {
                boolean isGlobalAnonymousAccessEnabled = this.spacePermissionManager.hasPermission("USECONFLUENCE", null, null);
                String defaultUsersGroup = this.getGlobalSettings().getDefaultUsersGroup();
                if (isGlobalAnonymousAccessEnabled) {
                    if (!this.spacePermissionManager.hasPermission("VIEWSPACE", siteHomePageParentSpace, null) && !this.spacePermissionManager.groupHasPermission("VIEWSPACE", siteHomePageParentSpace, defaultUsersGroup)) {
                        this.addActionError("site.homepage.invalid.permissions.error", new Object[]{siteHomePageParentSpace.getName(), defaultUsersGroup});
                    }
                } else if (!this.spacePermissionManager.groupHasPermission("VIEWSPACE", siteHomePageParentSpace, defaultUsersGroup)) {
                    this.addActionError("site.homepage.invalid.permissions.error", new Object[]{siteHomePageParentSpace.getName(), defaultUsersGroup});
                }
            }
        }
    }

    public String execute() {
        this.validation();
        if (this.hasErrors()) {
            return "error";
        }
        Settings originalSettings = this.getGlobalSettings();
        String oldDomainName = this.getGlobalSettings().getBaseUrl();
        this.saveSetupOptions();
        GlobalSettingsChangedEvent event = new GlobalSettingsChangedEvent((Object)this, originalSettings, this.getGlobalSettings(), oldDomainName, this.getGlobalSettings().getBaseUrl());
        this.eventPublisher.publish((Object)event);
        return "success";
    }

    private void saveSetupOptions() {
        Settings settings = new Settings(this.getGlobalSettings());
        settings.setAllowThreadedComments(this.allowThreadedComments);
        settings.setEnableQuickNav(this.enableQuickNav);
        settings.setEnableOpenSearch(this.enableOpenSearch);
        settings.setMaxSimultaneousQuickNavRequests(this.maxSimultaneousQuickNavRequests);
        settings.setDraftSaveInterval(this.getDraftSaveInterval());
        settings.setSiteHomePage("dashboard".equals(this.siteHomePage) ? null : this.siteHomePage);
        if (this.isSystemAdmin()) {
            settings.setAllowRemoteApi(this.allowRemoteApi);
        }
        this.globalSettingsManager.updateGlobalSettings(settings);
    }

    public boolean isSystemAdmin() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public List<PairType> getSiteHomePages() {
        if (!this.editMode) {
            if (StringUtils.isBlank((CharSequence)this.siteHomePage)) {
                return Collections.singletonList(new PairType((Serializable)((Object)this.getText("dashboard")), (Serializable)((Object)"dashboard")));
            }
            return Collections.singletonList(new PairType((Serializable)((Object)this.siteHomePage), (Serializable)((Object)this.siteHomePage)));
        }
        List allSpaces = this.spaceManager.getAllSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).build());
        ArrayList<PairType> siteHomePages = new ArrayList<PairType>(allSpaces.size() + 1);
        siteHomePages.add(new PairType((Serializable)((Object)this.getText("dashboard")), (Serializable)((Object)"dashboard")));
        for (Space space : allSpaces) {
            siteHomePages.add(new PairType((Serializable)((Object)space.getKey()), (Serializable)((Object)space.getKey())));
        }
        return siteHomePages;
    }

    public String getSiteHomePage() {
        return this.siteHomePage;
    }

    @StrutsParameter
    public void setSiteHomePage(String siteHomePage) {
        this.siteHomePage = siteHomePage;
    }

    public int getDraftSaveIntervalMinutes() {
        return this.draftSaveIntervalMinutes;
    }

    @StrutsParameter
    public void setDraftSaveIntervalMinutes(int draftSaveIntervalMinutes) {
        this.draftSaveIntervalMinutes = draftSaveIntervalMinutes;
    }

    public int getDraftSaveIntervalSeconds() {
        return this.draftSaveIntervalSeconds;
    }

    @StrutsParameter
    public void setDraftSaveIntervalSeconds(int draftSaveIntervalSeconds) {
        this.draftSaveIntervalSeconds = draftSaveIntervalSeconds;
    }

    public String getCurrentTime(String dateFormatPattern) {
        return new SimpleDateFormat(dateFormatPattern).format(new Date());
    }

    public String getNiceDraftSaveInterval() {
        return SpacesConfigurationAction.getNiceDuration(this.draftSaveIntervalMinutes, this.draftSaveIntervalSeconds);
    }

    public boolean isAllowThreadedComments() {
        return this.allowThreadedComments;
    }

    @StrutsParameter
    public void setAllowThreadedComments(boolean allowThreadedComments) {
        this.allowThreadedComments = allowThreadedComments;
    }

    public boolean isAllowRemoteApi() {
        return this.allowRemoteApi;
    }

    @StrutsParameter
    public void setAllowRemoteApi(boolean allowRemoteApi) {
        this.allowRemoteApi = allowRemoteApi;
    }

    public int getDraftSaveInterval() {
        return (this.draftSaveIntervalMinutes * 60 + this.draftSaveIntervalSeconds) * 1000;
    }

    public boolean isEnableQuickNav() {
        return this.enableQuickNav;
    }

    @StrutsParameter
    public void setEnableQuickNav(boolean enableQuickNav) {
        this.enableQuickNav = enableQuickNav;
    }

    public int getMaxSimultaneousQuickNavRequests() {
        return this.maxSimultaneousQuickNavRequests;
    }

    @StrutsParameter
    public void setMaxSimultaneousQuickNavRequests(int maxSimultaneousQuickNavRequests) {
        this.maxSimultaneousQuickNavRequests = maxSimultaneousQuickNavRequests;
    }

    public boolean isEnableOpenSearch() {
        return this.enableOpenSearch;
    }

    @StrutsParameter
    public void setEnableOpenSearch(boolean enableOpenSearch) {
        this.enableOpenSearch = enableOpenSearch;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    private static String getNiceDuration(int minutes, int seconds) {
        Object result = "";
        if (minutes > 0) {
            result = (String)result + minutes + " minute" + (minutes > 1 ? "s" : "") + " ";
        }
        if (seconds > 0) {
            result = (String)result + seconds + " second" + (seconds > 1 ? "s" : "");
        }
        return result;
    }
}

