/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.botkiller;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotKiller
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(BotKiller.class);
    private static final String SYSTEM_PROPERTY_BASE = BotKiller.class.getName() + ".";
    private static final int DEFAULT_ANONYMOUS_LOW_INACTIVE_TIMEOUT = 60;
    private static final int DEFAULT_USER_LOW_INACTIVE_TIMEOUT = 600;
    private static final int DEFAULT_ANONYMOUS_ACTIVE_TIMEOUT = 3600;
    private final UserManager userManager;
    private final int anonymousLowInactiveTimeout;
    private final int userLowInactiveTimeout;
    private final int anonymousActiveTimeout;
    private final int minimumTimeout;
    private boolean userManagerIsAvailable = false;

    public BotKiller(UserManager userManager) {
        this(userManager, Integer.getInteger(SYSTEM_PROPERTY_BASE + "anonymousLowInactiveTimeout", 60), Integer.getInteger(SYSTEM_PROPERTY_BASE + "userLowInactiveTimeout", 600), Integer.getInteger(SYSTEM_PROPERTY_BASE + "anonymousActiveTimeout", 3600));
    }

    public BotKiller(UserManager userManager, int anonymousLowInactiveTimeout, int userLowInactiveTimeout, int anonymousActiveTimeout) {
        this.userManager = userManager;
        this.anonymousLowInactiveTimeout = anonymousLowInactiveTimeout;
        this.userLowInactiveTimeout = userLowInactiveTimeout;
        this.anonymousActiveTimeout = anonymousActiveTimeout;
        this.minimumTimeout = Math.min(anonymousLowInactiveTimeout, Math.min(userLowInactiveTimeout, anonymousActiveTimeout));
    }

    void processRequest(HttpServletRequest httpServletRequest) {
        try {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null) {
                return;
            }
            this.fiddleWithSession(httpServletRequest, httpSession);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void fiddleWithSession(HttpServletRequest httpServletRequest, HttpSession httpSession) throws IllegalStateException {
        Integer initialMaxInactiveTimeout = (Integer)httpSession.getAttribute(BotKiller.class.getName());
        if (initialMaxInactiveTimeout == null) {
            initialMaxInactiveTimeout = httpSession.getMaxInactiveInterval();
            if (initialMaxInactiveTimeout <= this.minimumTimeout) {
                return;
            }
            httpSession.setAttribute(BotKiller.class.getName(), (Object)initialMaxInactiveTimeout);
            int lowInactiveTimeout = this.thereIsAUserInPlay(httpServletRequest) ? this.userLowInactiveTimeout : this.anonymousLowInactiveTimeout;
            lowInactiveTimeout = Math.min(lowInactiveTimeout, initialMaxInactiveTimeout);
            httpSession.setMaxInactiveInterval(lowInactiveTimeout);
            if (log.isDebugEnabled()) {
                log.debug("Lowering session inactivity timeout to " + lowInactiveTimeout);
            }
        } else if (httpSession.getMaxInactiveInterval() != initialMaxInactiveTimeout.intValue()) {
            if (this.thereIsAUserInPlay(httpServletRequest)) {
                httpSession.setMaxInactiveInterval(initialMaxInactiveTimeout.intValue());
                if (log.isDebugEnabled()) {
                    log.debug("Upping session inactivity timeout to " + initialMaxInactiveTimeout);
                }
            } else {
                httpSession.setMaxInactiveInterval(Math.min(initialMaxInactiveTimeout, this.anonymousActiveTimeout));
                if (log.isDebugEnabled()) {
                    log.debug("Lowering session inactivity timeout to " + this.anonymousActiveTimeout + " for repeated anonymous request");
                }
            }
        }
    }

    private boolean thereIsAUserInPlay(HttpServletRequest httpServletRequest) {
        if (this.userManagerIsAvailable) {
            try {
                UserProfile user = this.userManager.getRemoteUser();
                if (user != null && user.getUsername() != null) {
                    return true;
                }
                if (httpServletRequest.getRemoteUser() != null) {
                    return true;
                }
            }
            catch (Exception e) {
                log.error("Error occurred when figuring out if the session has a user, assuming there is no user.", (Throwable)e);
            }
        }
        return false;
    }

    public void onStart() {
        this.userManagerIsAvailable = true;
    }

    public void onStop() {
        this.userManagerIsAvailable = false;
    }
}

