/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.botkiller;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.labs.botkiller.BotKiller;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class BotKillerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BotKillerFilter.class);
    private final BotKiller botKiller;

    public BotKillerFilter(BotKiller botkiller) {
        this.botKiller = botkiller;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (httpServletRequest.getAttribute(BotKillerFilter.class.getName()) != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        httpServletRequest.setAttribute(BotKillerFilter.class.getName(), (Object)Boolean.TRUE);
        filterChain.doFilter(servletRequest, servletResponse);
        this.botKiller.processRequest(httpServletRequest);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("The Atlassian BotKiller plugin has been started.");
    }

    public void destroy() {
        log.info("The Atlassian BotKiller plugin has stopped.");
    }
}

