/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.metadata.jira.aggregate;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.confluence.plugins.metadata.jira.exception.JiraMetadataException;
import com.atlassian.confluence.plugins.metadata.jira.helper.CapabilitiesHelper;
import com.atlassian.confluence.plugins.metadata.jira.helper.JiraMetadataErrorHelper;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraAggregate;
import com.atlassian.confluence.plugins.metadata.jira.util.GlobalPageIdUtil;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraAggregateProvider {
    private static final Logger log = LoggerFactory.getLogger(JiraAggregateProvider.class);
    private static final List<String> countedTypes = Arrays.asList("issue", "sprints", "version");
    private static final int AGGREGATE_TIMEOUT_SECS = Integer.getInteger("jira.metadata.aggregate.provider.timeout.secs", 5);
    private static final String THREAD_NAME_PREFIX = "JIRAMetadataPlugin_AggregateProvider";
    private static final int EXECUTOR_POOL_SIZE = Integer.getInteger("jira.metadata.aggregate.provider.executor.pool.size", 5);
    private static final int EXECUTOR_TASK_QUEUE_SIZE = Integer.getInteger("jira.metadata.aggregate.provider.executor.queue.size", 100);
    protected final CapabilitiesHelper capabilitiesHelper;
    private final RequestFactory requestFactory;
    private final HostApplication hostApplication;
    private final ObjectMapper objectMapper;
    private final ExecutorService executorService = new ThreadPoolExecutor(EXECUTOR_POOL_SIZE, EXECUTOR_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(EXECUTOR_TASK_QUEUE_SIZE), ThreadFactories.namedThreadFactory((String)"JIRAMetadataPlugin_AggregateProvider", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));

    @Autowired
    public JiraAggregateProvider(RequestFactory requestFactory, CapabilitiesHelper capabilitiesHelper, HostApplication hostApplication, ObjectMapperProvider objectMapperProvider) {
        this.requestFactory = requestFactory;
        this.capabilitiesHelper = capabilitiesHelper;
        this.hostApplication = hostApplication;
        this.objectMapper = objectMapperProvider.getObjectMapper();
    }

    public JiraAggregate getAggregateData(long pageId, JiraMetadataErrorHelper errorHelper) {
        ArrayList<Callable<JiraAggregate>> aggregateCallables = new ArrayList<Callable<JiraAggregate>>();
        log.debug("My base url {}, my appId {}", (Object)this.hostApplication.getBaseUrl(), (Object)ApplicationIdUtil.generate((URI)this.hostApplication.getBaseUrl()));
        for (ReadOnlyApplicationLink applink : this.capabilitiesHelper.getAggregateCapableJiraLinks()) {
            aggregateCallables.add(() -> {
                String requestUrl = "/rest/remote-link-aggregation/1/aggregation?globalId=" + HtmlUtil.urlEncode((String)GlobalPageIdUtil.generateGlobalPageId(ApplicationIdUtil.generate((URI)this.hostApplication.getBaseUrl()), pageId), (Charset)GeneralUtil.getDefaultCharset()) + "&globalId=" + HtmlUtil.urlEncode((String)GlobalPageIdUtil.generateGlobalPageId(this.hostApplication.getId(), pageId), (Charset)GeneralUtil.getDefaultCharset());
                return this.getDataForSingleApplink(applink, requestUrl, errorHelper);
            });
        }
        return this.consolidate(this.retrieveFutures(aggregateCallables, errorHelper));
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdownNow();
    }

    private JiraAggregate getDataForSingleApplink(ReadOnlyApplicationLink applink, String requestUrl, JiraMetadataErrorHelper errorHelper) {
        try {
            log.debug("Retrieving aggregate data for link {} ; requestURL: {}", (Object)applink.getName(), (Object)requestUrl);
            String response = this.requestFactory.createRequest(Request.MethodType.GET, String.valueOf(applink.getRpcUrl()) + requestUrl).execute();
            log.debug("The response is:\n {}", (Object)response);
            Iterable aggregates = this.parse(response, errorHelper).stream().filter(jiraAggregate -> jiraAggregate != null && countedTypes.contains(jiraAggregate.getEntityType())).collect(Collectors.toList());
            return this.consolidate(aggregates);
        }
        catch (Exception e) {
            errorHelper.handleException(e, applink);
            return null;
        }
    }

    private List<JiraAggregate> retrieveFutures(List<Callable<JiraAggregate>> callables, JiraMetadataErrorHelper errorHelper) {
        List<Future<JiraAggregate>> futures;
        ArrayList<JiraAggregate> aggregates = new ArrayList<JiraAggregate>();
        try {
            futures = this.executorService.invokeAll(callables, AGGREGATE_TIMEOUT_SECS, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            errorHelper.handleException(e);
            return aggregates;
        }
        for (Future<JiraAggregate> future : futures) {
            if (future.isCancelled()) {
                aggregates.add(null);
                continue;
            }
            try {
                JiraAggregate aggregate = future.get(AGGREGATE_TIMEOUT_SECS, TimeUnit.SECONDS);
                aggregates.add(aggregate);
            }
            catch (Exception e) {
                errorHelper.handleException(e);
            }
        }
        return aggregates;
    }

    JiraAggregate consolidate(Iterable<JiraAggregate> aggregates) {
        int count = 0;
        JiraAggregate singleEntity = null;
        boolean incomplete = false;
        for (JiraAggregate aggregate : aggregates) {
            if (aggregate != null) {
                count += aggregate.getCount();
                if (aggregate.isSingleEntity()) {
                    singleEntity = aggregate;
                }
                if (!aggregate.isIncomplete()) continue;
                incomplete = true;
                continue;
            }
            incomplete = true;
        }
        if (singleEntity != null && count == 1) {
            return new JiraAggregate(count, singleEntity.getEntityType(), singleEntity.getEntityName(), singleEntity.getEntityUrl(), incomplete);
        }
        return new JiraAggregate(count, incomplete);
    }

    List<JiraAggregate> parse(String response, JiraMetadataErrorHelper errorHelper) {
        ArrayList<JiraAggregate> aggregates = new ArrayList<JiraAggregate>();
        try {
            JsonNode responseObject = this.objectMapper.readTree(response).path("targets");
            responseObject.fields().forEachRemaining(entry -> {
                JsonNode responseArray = (JsonNode)entry.getValue();
                if (responseArray == null || !responseArray.isArray()) {
                    return;
                }
                for (JsonNode result : responseArray) {
                    JsonNode typeDetails = result.path("type");
                    JsonNode objectsElement = result.path("objects");
                    if (objectsElement.isArray() && !objectsElement.isEmpty()) {
                        JsonNode entity = objectsElement.get(0);
                        aggregates.add(new JiraAggregate(this.jsonToInt(result.path("count")), this.jsonToString(typeDetails.path("id")), this.jsonToString(entity.path("name")), this.jsonToString(entity.path("url")), false));
                        continue;
                    }
                    aggregates.add(new JiraAggregate(this.jsonToInt(result.path("count")), this.jsonToString(typeDetails.path("id"))));
                }
            });
        }
        catch (Exception e) {
            errorHelper.handleException(new JiraMetadataException(JiraMetadataErrorHelper.Status.RESPONSE_UNPARSABLE, (Throwable)e));
        }
        return aggregates;
    }

    private int jsonToInt(JsonNode node) {
        if (node == null || node.isNull()) {
            return 0;
        }
        return node.asInt();
    }

    private String jsonToString(JsonNode node) {
        if (node == null || node.isNull()) {
            return null;
        }
        return node.asText();
    }
}

