/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.metadata.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.metadata.jira.service.JiraMetadataService;
import com.atlassian.confluence.plugins.metadata.jira.util.GlobalPageIdUtil;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@Path(value="metadata")
@Produces(value={"application/json"})
public class JiraMetadataResource {
    private final JiraMetadataService jiraMetadataService;

    @Inject
    public JiraMetadataResource(JiraMetadataService jiraMetadataService) {
        this.jiraMetadataService = jiraMetadataService;
    }

    @AnonymousSiteAccess
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getMetadata(@QueryParam(value="pageId") long pageId) {
        return Response.ok((Object)this.jiraMetadataService.getMetadata(pageId)).build();
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="/aggregate")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getAggregateData(@QueryParam(value="pageId") long pageId) {
        return Response.ok((Object)this.jiraMetadataService.getAggregateData(pageId)).build();
    }

    @DELETE
    @Path(value="/cache")
    @UnrestrictedAccess
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response invalidateCachedAggregateData(@QueryParam(value="globalId") String globalId) {
        Long pageId = GlobalPageIdUtil.getPageId(globalId);
        if (pageId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.jiraMetadataService.invalidateCachedAggregateData(pageId);
        return Response.ok().build();
    }
}

