/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.metadata.jira.service;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataGroup;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataIssueItem;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataIssueStatus;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataIssueStatusCategory;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataItem;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataSingleGroup;
import com.atlassian.confluence.plugins.metadata.jira.service.JiraMetadataDelegate;
import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JiraIssuesMetadataDelegate
implements JiraMetadataDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraIssuesMetadataDelegate.class);
    private static final String REST_JQL_JVIS_DC_PATH = "/rest/api/2/search";
    private static final String REST_JQL_JSIS_CLOUD_PATH = "/rest/api/2/search/jql";
    private final ObjectMapper objectMapper = new DefaultObjectMapperProvider().getObjectMapper();

    @Override
    @Deprecated(since="21.0.5")
    public String getUrl(List<String> globalIds, Map<String, String> parameters) {
        return this.getUrl(globalIds, parameters, false);
    }

    @Override
    public String getUrl(List<String> globalIds, Map<String, String> parameters, boolean isCloud) {
        if (isCloud) {
            JiraIssuesMetadataDelegate.logTraceJSISUsage();
        }
        String jqlConditions = JiraIssuesMetadataDelegate.getJqlConditions(globalIds);
        Object url = isCloud ? REST_JQL_JSIS_CLOUD_PATH : REST_JQL_JVIS_DC_PATH;
        url = (String)url + "?jql=issue+in+(" + HtmlUtil.urlEncode((String)jqlConditions, (Charset)GeneralUtil.getDefaultCharset()) + ")";
        if (parameters.containsKey("epicNameField")) {
            url = (String)url + "&fields=summary,issuetype,status," + parameters.get("epicNameField");
        }
        return url;
    }

    private static String getJqlConditions(List<String> globalIds) {
        return Joiner.on((char)',').join((Iterable)Collections2.transform(globalIds, input -> "issuesWithRemoteLinksByGlobalId('" + input + "')"));
    }

    @Override
    public List<JiraMetadataSingleGroup> getGroups(ReadOnlyApplicationLink jiraAppLink, ApplicationLinkRequest request, Map<String, String> parameters, List<String> globalIds) throws ResponseException, JsonProcessingException {
        ArrayList<JiraMetadataItem> issues = new ArrayList<JiraMetadataItem>();
        ArrayList<JiraMetadataItem> epics = new ArrayList<JiraMetadataItem>();
        JsonNode result = this.objectMapper.readTree(request.execute());
        for (JsonNode element : result.get("issues")) {
            JsonNode fields = element.get("fields");
            String key = element.get("key").asText();
            String summary = fields.get("summary").asText();
            JiraMetadataIssueStatus status = this.constructIssueStatus(fields.get("status"));
            String issueTypeId = fields.get("issuetype").get("id").asText();
            if (issueTypeId.equals(parameters.get("epicTypeId"))) {
                JsonNode epicName = fields.get(parameters.get("epicNameField"));
                String name = epicName != null && !epicName.isNull() ? epicName.asText() : key;
                epics.add(new JiraMetadataItem(name, summary, String.valueOf(jiraAppLink.getDisplayUrl()) + "/browse/" + key));
                continue;
            }
            issues.add(new JiraMetadataIssueItem(key, summary, String.valueOf(jiraAppLink.getDisplayUrl()) + "/browse/" + key, status));
        }
        return Arrays.asList(new JiraMetadataSingleGroup(JiraMetadataGroup.Type.ISSUES, issues, jiraAppLink, this.getDisplayURL(jiraAppLink, globalIds, parameters, JiraMetadataGroup.Type.ISSUES)), new JiraMetadataSingleGroup(JiraMetadataGroup.Type.EPICS, epics, jiraAppLink, this.getDisplayURL(jiraAppLink, globalIds, parameters, JiraMetadataGroup.Type.EPICS)));
    }

    private JiraMetadataIssueStatus constructIssueStatus(JsonNode root) {
        JiraMetadataIssueStatusCategory category = null;
        if (root.has("statusCategory")) {
            JsonNode categoryRoot = root.get("statusCategory");
            String categoryKey = categoryRoot.get("key").asText();
            String colorName = categoryRoot.get("colorName").asText();
            category = new JiraMetadataIssueStatusCategory(categoryKey, colorName);
        }
        String name = root.get("name").asText();
        String description = root.get("description").asText();
        return new JiraMetadataIssueStatus(name, description, category);
    }

    private String getDisplayURL(ReadOnlyApplicationLink jiraAppLink, List<String> globalId, Map<String, String> parameters, JiraMetadataGroup.Type type) {
        return String.valueOf(jiraAppLink.getDisplayUrl()) + "/issues/?jql=" + HtmlUtil.urlEncode((String)("issue in (" + JiraIssuesMetadataDelegate.getJqlConditions(globalId) + ") and issuetype" + (type.equals((Object)JiraMetadataGroup.Type.EPICS) ? "=" : "!=") + parameters.get("epicTypeId")), (Charset)GeneralUtil.getDefaultCharset());
    }

    @Override
    public boolean isSupported(ReadOnlyApplicationLink jiraAppLink) {
        return true;
    }

    private static void logTraceJSISUsage() {
        LOGGER.trace("Using '{}' JSIS endpoint for Jira Cloud application link as '{}' JVIS one is deprecated", (Object)REST_JQL_JSIS_CLOUD_PATH, (Object)REST_JQL_JVIS_DC_PATH);
    }
}

