/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.metadata.jira.service;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataGroup;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataItem;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraMetadataSingleGroup;
import com.atlassian.confluence.plugins.metadata.jira.service.JiraMetadataDelegate;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.sal.api.net.ResponseException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JiraVersionsMetadataDelegate
implements JiraMetadataDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraVersionsMetadataDelegate.class);
    private static final String REST_JQL_JVIS_DC_PATH = "/rest/api/2/search";
    private static final String REST_JQL_JSIS_CLOUD_PATH = "/rest/api/2/search/jql";

    @Override
    @Deprecated(since="20.1.5")
    public String getUrl(List<String> globalId, Map<String, String> parameters) {
        return this.getUrl(globalId, parameters, false);
    }

    @Override
    public String getUrl(List<String> globalId, Map<String, String> parameters, boolean isCloud) {
        if (isCloud) {
            JiraVersionsMetadataDelegate.logTraceJSISUsage();
        }
        Object url = isCloud ? REST_JQL_JSIS_CLOUD_PATH : REST_JQL_JVIS_DC_PATH;
        url = (String)url + "?jql=" + HtmlUtil.urlEncode((String)"summary IS EMPTY", (Charset)GeneralUtil.getDefaultCharset());
        return url;
    }

    @Override
    public List<JiraMetadataSingleGroup> getGroups(ReadOnlyApplicationLink jiraAppLink, ApplicationLinkRequest request, Map<String, String> parameters, List<String> globalId) throws ResponseException {
        ArrayList<JiraMetadataItem> items = new ArrayList<JiraMetadataItem>();
        return Collections.singletonList(new JiraMetadataSingleGroup(JiraMetadataGroup.Type.VERSIONS, items, jiraAppLink));
    }

    @Override
    public boolean isSupported(ReadOnlyApplicationLink jiraAppLink) {
        return false;
    }

    private static void logTraceJSISUsage() {
        LOGGER.trace("Using '{}' JSIS endpoint for Jira Cloud application link as '{}' JVIS one is deprecated", (Object)REST_JQL_JSIS_CLOUD_PATH, (Object)REST_JQL_JVIS_DC_PATH);
    }
}

