/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.bootstrap;

import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.plugin.PluginDisableEvent;
import com.atlassian.confluence.plugins.synchrony.api.OperationContext;
import com.atlassian.confluence.plugins.synchrony.api.SynchronyProcessManager;
import com.atlassian.confluence.plugins.synchrony.api.events.SynchronyRestartedEvent;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LifecycleAware.class})
public class SynchronyInteropBootstrap
implements LifecycleAware,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SynchronyInteropBootstrap.class);
    private final SynchronyProcessManager processManager;
    private final EventPublisher eventPublisher;
    private final BootstrapManager bootstrapManager;

    @Autowired
    public SynchronyInteropBootstrap(SynchronyProcessManager processManager, @ComponentImport EventPublisher eventPublisher, @ComponentImport BootstrapManager bootstrapManager) {
        this.processManager = processManager;
        this.eventPublisher = eventPublisher;
        this.bootstrapManager = bootstrapManager;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
        this.processManager.stop();
    }

    @EventListener
    public void onGlobalSettingsChangeEvent(GlobalSettingsChangedEvent globalSettingsChangedEvent) {
        String newBaseUrl;
        String oldBaseUrl = globalSettingsChangedEvent.getOldSettings().getBaseUrl();
        if (!oldBaseUrl.equalsIgnoreCase(newBaseUrl = globalSettingsChangedEvent.getNewSettings().getBaseUrl())) {
            this.processManager.restart(OperationContext.builder().setOverloadBaseUrl(newBaseUrl).build()).done(result -> this.eventPublisher.publish((Object)new SynchronyRestartedEvent(new Object(), (boolean)result))).fail(error -> this.eventPublisher.publish((Object)new SynchronyRestartedEvent(new Object(), false)));
        }
    }

    @EventListener
    public void onGlobalSettingsChangeEvent(ClusterEventWrapper wrapper) {
        if (wrapper.getEvent() instanceof GlobalSettingsChangedEvent) {
            this.onGlobalSettingsChangeEvent((GlobalSettingsChangedEvent)wrapper.getEvent());
        }
    }

    public void onStart() {
        if (this.bootstrapManager.isSetupComplete()) {
            log.info("Starting Synchrony process");
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.processManager.startup().done(result -> {
                if (result.booleanValue()) {
                    log.info("Synchrony started successfully in {}", (Object)stopwatch.elapsed());
                } else {
                    log.warn("Synchrony failed to start after {}", (Object)stopwatch.elapsed());
                }
            }).fail(ex -> log.warn("Synchrony startup failure", ex));
        }
    }

    public void onStop() {
        this.processManager.stop();
    }

    @EventListener
    public void onPluginStopped(PluginDisableEvent pluginDisableEvent) {
        if ("com.atlassian.confluence.plugins.synchrony-interop".equals(pluginDisableEvent.getPluginKey())) {
            this.processManager.stop();
        }
    }

    @EventListener
    public void onPluginStopped(ClusterEventWrapper wrapper) {
        if (wrapper.getEvent() instanceof PluginDisableEvent) {
            this.onPluginStopped((PluginDisableEvent)wrapper.getEvent());
        }
    }
}

