/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.service;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="collaborativeEditingModeDuration")
public class CollaborativeEditingModeDuration {
    @VisibleForTesting
    static final long UNKNOWN_DURATION = -1L;
    @VisibleForTesting
    static final String LAST_MODE_CHANGE_KEY = "atlassian.confluence.last.collaborative.editing.mode.change.time";
    private final PluginSettings globalPluginSettings;
    private final DateProvider dateProvider;

    @Autowired
    public CollaborativeEditingModeDuration(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this(pluginSettingsFactory, new DateProvider());
    }

    @VisibleForTesting
    CollaborativeEditingModeDuration(PluginSettingsFactory pluginSettingsFactory, DateProvider dateProvider) {
        this.globalPluginSettings = Objects.requireNonNull(pluginSettingsFactory).createGlobalSettings();
        this.dateProvider = Objects.requireNonNull(dateProvider);
    }

    public long currentModeDuration(TimeUnit timeUnit) {
        Optional<Long> lastModeChangeTime = this.getLastModeChangeTime();
        if (lastModeChangeTime.isEmpty()) {
            return -1L;
        }
        long differenceInMillis = this.dateProvider.getDate().getTime() - lastModeChangeTime.get();
        return timeUnit.convert(differenceInMillis, TimeUnit.MILLISECONDS);
    }

    public void storeModeChangeTime() {
        this.globalPluginSettings.put(LAST_MODE_CHANGE_KEY, (Object)this.dateProvider.getDate().getTime());
    }

    private Optional<Long> getLastModeChangeTime() {
        return Optional.ofNullable((Long)this.globalPluginSettings.get(LAST_MODE_CHANGE_KEY));
    }

    @VisibleForTesting
    static class DateProvider {
        DateProvider() {
        }

        Date getDate() {
            return new Date();
        }
    }
}

