/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.status;

import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.status.service.SynchronyStatusService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.wrapped.JsonableBoolean;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import java.util.Objects;

public class SynchronyBannerDataProvider
implements WebResourceDataProvider {
    private final SynchronyConfigurationManager synchronyConfigurationManager;
    private final SynchronyStatusService synchronyStatusService;
    private final PermissionManager permissionManager;

    public SynchronyBannerDataProvider(@ComponentImport SynchronyConfigurationManager synchronyConfigurationManager, @ComponentImport PermissionManager permissionManager, SynchronyStatusService synchronyStatusService) {
        this.synchronyConfigurationManager = Objects.requireNonNull(synchronyConfigurationManager);
        this.synchronyStatusService = Objects.requireNonNull(synchronyStatusService);
        this.permissionManager = Objects.requireNonNull(permissionManager);
    }

    public Jsonable get() {
        return new JsonableBoolean(Boolean.valueOf(this.isSysAdmin() && this.isCollabEditingOn() && !this.synchronyStatusService.isSynchronyRunning()));
    }

    private boolean isCollabEditingOn() {
        return this.synchronyConfigurationManager.isSharedDraftsEnabled();
    }

    private boolean isSysAdmin() {
        return this.permissionManager.isSystemAdministrator(AuthenticatedUserThreadLocal.get());
    }
}

