/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.status;

import com.atlassian.confluence.plugins.synchrony.api.SynchronyMonitor;
import com.atlassian.confluence.plugins.synchrony.api.SynchronyProcessManager;
import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.confluence.plugins.synchrony.status.SynchronyStatusCache;
import com.atlassian.confluence.plugins.synchrony.status.SynchronyStatusEventPublisher;
import com.atlassian.confluence.status.service.SynchronyStatusService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="synchronyStatusCheckJob")
public final class SynchronyStatusCheckJob
implements JobRunner {
    @VisibleForTesting
    static final String FAIL_MESSAGE = "Did not put the Synchrony Status into the cache.";
    private static final Logger log = LoggerFactory.getLogger(SynchronyStatusCheckJob.class);
    private final SynchronyMonitor synchronyMonitor;
    private final SynchronyStatusService synchronyStatusService;
    private final SynchronyStatusEventPublisher synchronyStatusEventPublisher;
    private final SynchronyConfigurationManager synchronyConfigurationManager;
    private final SynchronyProcessManager synchronyProcessManager;

    @Autowired
    public SynchronyStatusCheckJob(SynchronyMonitor synchronyMonitor, SynchronyProcessManager synchronyProcessManager, SynchronyStatusService synchronyStatusService, SynchronyStatusEventPublisher synchronyStatusEventPublisher, @ComponentImport(value="synchronyConfigurationManager") SynchronyConfigurationManager synchronyConfigurationManager) {
        this.synchronyMonitor = Objects.requireNonNull(synchronyMonitor);
        this.synchronyStatusService = Objects.requireNonNull(synchronyStatusService);
        this.synchronyStatusEventPublisher = Objects.requireNonNull(synchronyStatusEventPublisher);
        this.synchronyConfigurationManager = Objects.requireNonNull(synchronyConfigurationManager);
        this.synchronyProcessManager = Objects.requireNonNull(synchronyProcessManager);
    }

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest request) {
        log.debug("Checking Synchrony Status...");
        if (!this.synchronyConfigurationManager.isSharedDraftsEnabled()) {
            System.setProperty("atlassian.internal.synchrony.status", "false");
            log.debug("Collaborative editing is disabled. Not updating the synchrony status in the cache.");
            return JobRunnerResponse.success();
        }
        if (this.synchronyProcessManager.isSynchronyStartingUp()) {
            System.setProperty("atlassian.internal.synchrony.status", "false");
            log.debug("Synchrony is still starting up. Not updating the synchrony status in the cache.");
            return JobRunnerResponse.success();
        }
        try {
            SynchronyStatusCache synchronyStatusCache = (SynchronyStatusCache)this.synchronyStatusService;
            Optional<Boolean> realCacheValue = synchronyStatusCache.getStatus();
            boolean wasPreviouslyRunning = this.synchronyStatusService.isSynchronyRunning();
            boolean isRunningNow = this.synchronyMonitor.isSynchronyUp();
            log.debug("Synchrony is running: {}", (Object)isRunningNow);
            if (realCacheValue.isPresent()) {
                this.synchronyStatusEventPublisher.decideEvents(isRunningNow, wasPreviouslyRunning);
            }
            synchronyStatusCache.setStatus(isRunningNow);
            log.debug("Setting the system property {} to {}", (Object)"atlassian.internal.synchrony.status", (Object)isRunningNow);
            System.setProperty("atlassian.internal.synchrony.status", String.valueOf(isRunningNow));
            return JobRunnerResponse.success();
        }
        catch (RuntimeException e) {
            log.error(FAIL_MESSAGE, (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }
}

