/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.tasks;

import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.plugins.synchrony.tasks.AbstractConfigLongRunningTask;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.Serializable;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SynchronyConfigTaskTracker {
    private static final Logger log = LoggerFactory.getLogger(SynchronyConfigTaskTracker.class);
    static final String PLUGIN_SETTINGS_NAMESPACE = "com.atlassian.confluence.plugins.synchrony.tasks";
    static final String PLUGIN_SETTINGS_KEY = "taskTrackingMetadata";
    private final LongRunningTaskManager taskManager;
    private final PluginSettings pluginSettings;
    private final ConfluenceJsonObjectMapper jsonObjectMapper = new ConfluenceJsonObjectMapper();

    @Autowired
    public SynchronyConfigTaskTracker(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport LongRunningTaskManager taskManager) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(PLUGIN_SETTINGS_NAMESPACE);
        this.taskManager = taskManager;
    }

    public @Nullable String getTaskId() {
        return this.getCachedMetadata().map(SynchronyTaskMetadata::getTaskId).orElse(null);
    }

    public @Nullable String getTaskName() {
        return this.getCachedMetadata().map(SynchronyTaskMetadata::getTaskName).orElse(null);
    }

    private Optional<SynchronyTaskMetadata> getCachedMetadata() {
        try {
            String synchronyTaskMetadataJson = (String)this.pluginSettings.get(PLUGIN_SETTINGS_KEY);
            return Optional.ofNullable((SynchronyTaskMetadata)this.jsonObjectMapper.deserializeOrNull(synchronyTaskMetadataJson, SynchronyTaskMetadata.class));
        }
        catch (RuntimeException ex) {
            log.error("Failed to get status of Synchrony task cache", (Throwable)ex);
            return Optional.empty();
        }
    }

    public LongRunningTaskId startTask(AbstractConfigLongRunningTask task) {
        LongRunningTaskId taskId = this.taskManager.startLongRunningTask(AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
        SynchronyTaskMetadata taskMetadata = new SynchronyTaskMetadata(taskId.asLongTaskId().serialise(), task.getName());
        try {
            String taskMetadataJson = this.jsonObjectMapper.serialize((Object)taskMetadata);
            this.pluginSettings.put(PLUGIN_SETTINGS_KEY, (Object)taskMetadataJson);
        }
        catch (RuntimeException ex) {
            log.error("Failed to get status of Synchrony task cache", (Throwable)ex);
        }
        return taskId;
    }

    public void taskDone() {
        this.pluginSettings.remove(PLUGIN_SETTINGS_KEY);
    }

    static class SynchronyTaskMetadata
    implements Serializable {
        private static final long serialVersionUID = 8327482342734829L;
        private String taskId;
        private String taskName;

        private SynchronyTaskMetadata() {
        }

        SynchronyTaskMetadata(String taskId, String taskName) {
            this.taskId = taskId;
            this.taskName = taskName;
        }

        String getTaskId() {
            return this.taskId;
        }

        String getTaskName() {
            return this.taskName;
        }
    }
}

