/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationPayload;
import com.atlassian.confluence.notifications.ProductionAwareLoggerSwitch;
import com.atlassian.confluence.notifications.content.WatchTypeBasedRecipientProvider;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.AuthenticatedUserImpersonator;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;

public abstract class AuthenticatedRecipientProvider<PAYLOAD extends NotificationPayload>
extends WatchTypeBasedRecipientProvider<PAYLOAD> {
    private static final ProductionAwareLoggerSwitch log = ProductionAwareLoggerSwitch.forCaller();
    private final UserAccessor userAccessor;

    protected AuthenticatedRecipientProvider(Class<PAYLOAD> payloadType, TransactionTemplate transactionTemplate, NotificationManager notificationManager, PageManager pageManager, UserAccessor userAccessor, PermissionManager permissionManager, ContentEntityManager contentEntityManager, ConfluenceAccessManager confluenceAccessManager) {
        super(payloadType, transactionTemplate, notificationManager, pageManager, permissionManager, contentEntityManager, confluenceAccessManager);
        this.userAccessor = userAccessor;
    }

    @Override
    protected final Iterable<com.atlassian.confluence.mail.notification.Notification> computeNotifications(Notification<PAYLOAD> notification) {
        if (notification.getPayload().getOriginatorUserKey().isEmpty()) {
            log.onlyTrace("Notification triggered by anonymous user, authentication not required.", notification.toString());
            return this.computeNotificationsInContextOfNotifier(notification);
        }
        UserKey userKey = (UserKey)notification.getPayload().getOriginatorUserKey().get();
        ConfluenceUser user = this.userAccessor.getExistingUserByKey(userKey);
        return (Iterable)AuthenticatedUserImpersonator.REQUEST_AGNOSTIC.asUser(() -> this.computeNotificationsInContextOfNotifier(notification), user);
    }

    protected abstract Iterable<com.atlassian.confluence.mail.notification.Notification> computeNotificationsInContextOfNotifier(Notification<PAYLOAD> var1);
}

