/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content;

import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationPayload;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.spi.UserRole;
import java.util.Map;
import java.util.Optional;

public abstract class ContentRenderContextFactory<PAYLOAD extends NotificationPayload>
extends RenderContextProviderTemplate<PAYLOAD> {
    protected ContentRenderContextFactory(Class<PAYLOAD> payloadType) {
        super(payloadType);
    }

    protected Optional<Map<String, Object>> checkedCreate(Notification<PAYLOAD> notification, ServerConfiguration serverConfiguration, NotificationAddress notificationAddress) {
        return Optional.empty();
    }

    protected Optional<Map<String, Object>> checkedCreate(Notification<PAYLOAD> notification, ServerConfiguration serverConfiguration, RoleRecipient recipient) {
        boolean isForCurrentUser;
        boolean bl = isForCurrentUser = AuthenticatedUserThreadLocal.get() != null && AuthenticatedUserThreadLocal.get().getKey().equals((Object)recipient.getUserKey());
        if (!isForCurrentUser) {
            throw new IllegalArgumentException(String.format("This factory requires the [%s] to be set to the recipient since the [%s] will perform a VIEW permission check in order to provide the content.", AuthenticatedUserThreadLocal.class, ContentService.class));
        }
        Optional<NotificationContext> maybeContext = this.createForRecipient(notification, serverConfiguration, recipient);
        if (maybeContext.isPresent()) {
            NotificationContext context = maybeContext.get();
            ContentRenderContextFactory.computeWatchTypeFrom(recipient.getRole()).ifPresent(arg_0 -> ((NotificationContext)context).setWatchType(arg_0));
            return Optional.of(context.getMap());
        }
        return Optional.empty();
    }

    private static Optional<Notification.WatchType> computeWatchTypeFrom(UserRole role) {
        try {
            return Optional.of(Notification.WatchType.valueOf((String)role.getID()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    protected abstract Optional<NotificationContext> createForRecipient(Notification<PAYLOAD> var1, ServerConfiguration var2, RoleRecipient var3);
}

